/*
 * Decompiled with CFR 0.152.
 */
package pdp.provision;

import java.io.IOException;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import pdp.JsonMapper;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.repositories.PdpPolicyRepository;
import pdp.xacml.PolicyTemplateEngine;

public class PolicyProvisioner
implements ApplicationListener<ContextStartedEvent>,
JsonMapper {
    private final PolicyTemplateEngine policyTemplateEngine = new PolicyTemplateEngine();
    private final PdpPolicyRepository pdpPolicyRepository;
    private final String path;

    @Autowired
    public PolicyProvisioner(@Value(value="${provision.policies.directory}") String path, PdpPolicyRepository pdpPolicyRepository) {
        this.path = path;
        this.pdpPolicyRepository = pdpPolicyRepository;
    }

    public void onApplicationEvent(ContextStartedEvent contextStartedEvent) {
        this.policyDefinitions().filter(definition -> !this.pdpPolicyRepository.findByNameAndLatestRevision(definition.getName(), true).isPresent()).forEach(definition -> {
            String policyXml = this.policyTemplateEngine.createPolicyXml(definition);
            PdpPolicy pdpPolicy = new PdpPolicy(policyXml, definition.getName(), true, "provisioned", "surfnet", "system", true, definition.getType());
            this.pdpPolicyRepository.save((Object)pdpPolicy);
        });
    }

    private PdpPolicyDefinition parse(Resource resource) {
        try {
            return (PdpPolicyDefinition)objectMapper.readValue(resource.getInputStream(), PdpPolicyDefinition.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<PdpPolicyDefinition> policyDefinitions() {
        try {
            return Stream.of(new PathMatchingResourcePatternResolver().getResources(String.format("classpath:%s/*.json", this.path))).map(arg_0 -> this.parse(arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

