/*
 * Decompiled with CFR 0.152.
 */
package provisioning.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;
import provisioning.model.Provisioning;
import provisioning.model.ProvisioningType;
import provisioning.repository.ProvisioningRepository;

@Controller
public class ProvisioningController {
    private final String environment;
    private final ProvisioningRepository provisioningRepository;
    private final ObjectMapper objectMapper;

    public ProvisioningController(@Value(value="${environment}") String environment, ProvisioningRepository provisioningRepository, ObjectMapper objectMapper) {
        this.environment = environment;
        this.provisioningRepository = provisioningRepository;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/"})
    public ModelAndView index() {
        return new ModelAndView("index", Map.of("environment", this.environment));
    }

    @GetMapping(value={"/provisionings/{type}"})
    public ModelAndView allProvisionings(@PathVariable(value="type") ProvisioningType provisioningType) {
        return new ModelAndView("provisionings", Map.of("provisionings", this.provisioningRepository.findByProvisioningTypeOrderByCreatedAtDesc(provisioningType), "provisioningType", provisioningType.name(), "environment", this.environment));
    }

    @GetMapping(value={"/provisioning/{id}"})
    public ModelAndView provisioning(@PathVariable(value="id") Long id) throws JsonProcessingException {
        Provisioning provisioning = (Provisioning)this.provisioningRepository.findById((Object)id).orElseThrow(IllegalArgumentException::new);
        String s = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)provisioning.getMessage()).replaceAll("\n", "<br/>");
        provisioning.setPrettyMessage(s);
        return new ModelAndView("provisioning", Map.of("provisioning", provisioning, "environment", this.environment));
    }

    @GetMapping(value={"/delete/provisionings/{type}"})
    public ModelAndView deleteProvisionings(@PathVariable(value="type") ProvisioningType provisioningType) {
        this.provisioningRepository.deleteAll((Iterable)this.provisioningRepository.findByProvisioningTypeOrderByCreatedAtDesc(provisioningType));
        return this.allProvisionings(provisioningType);
    }

    @GetMapping(value={"/delete/provisioning/{type}/{id}"})
    public ModelAndView deleteProvisioning(@PathVariable(value="type") ProvisioningType provisioningType, @PathVariable(value="id") Long id) {
        this.provisioningRepository.deleteById((Object)id);
        return this.allProvisionings(provisioningType);
    }
}

