/*
 * Decompiled with CFR 0.152.
 */
package broker.api;

import broker.LanguageFilter;
import broker.domain.BrokerRequest;
import broker.domain.CourseAuthentication;
import broker.domain.EnrollmentRequest;
import broker.domain.Institution;
import broker.exception.RemoteException;
import broker.queue.QueueService;
import broker.registry.InstitutionRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class BrokerController {
    public static final String BROKER_REQUEST_SESSION_KEY = "BROKER_REQUEST_SESSION_KEY";
    public static final String OFFERING_SESSION_KEY = "OFFERING_SESSION_KEY";
    private static final Log LOG = LogFactory.getLog(BrokerController.class);
    private final String clientUrl;
    private final InstitutionRegistry institutionRegistry;
    private final QueueService queueService;
    private final RestTemplate restTemplate;
    private final Map<String, Object> featureToggles = new HashMap();
    private final URI tokenEndpoint;
    private final String clientId;
    private final String secret;
    private final String sisUser;
    private final String sisPassword;
    private final String sisResultsEndpoint;
    private final URI eduHubGatewayUrl;
    private final String eduHubUser;
    private final String eduHubPassword;
    private final ParameterizedTypeReference<Map<String, Object>> mapRef = new /* Unavailable Anonymous Inner Class!! */;

    public BrokerController(@Value(value="${config.broker_client_url}") String clientUrl, @Value(value="${config.start_broker_endpoint}") String startBrokerEndpoint, @Value(value="${config.oauth2.token_endpoint}") URI tokenEndpoint, @Value(value="${config.oauth2.client_id}") String clientId, @Value(value="${config.oauth2.secret}") String secret, @Value(value="${config.sis_user}") String sisUser, @Value(value="${config.sis_password}") String sisPassword, @Value(value="${config.sis_results_endpoint}") String sisResultsEndpoint, @Value(value="${config.local}") boolean local, @Value(value="${config.allow_playground}") boolean allowPlayground, @Value(value="${config.poll_enabled}") boolean pollEnabled, @Value(value="${config.survey_enabled}") boolean surveyEnabled, @Value(value="${config.poll_survey}") URI pollSurvey, @Value(value="${config.play_home_institution_schacHome}") String playHomeInstitutionSchacHome, @Value(value="${config.play_guest_institution_schacHome}") String playGuestInstitutionSchacHome, @Value(value="${config.play_alliance}") String playAlliance, @Value(value="${config.play_offering_id}") String playOfferingID, @Value(value="${config.catalog_url}") String catalogUrl, @Value(value="${config.connection_timeout_millis}") int connectionTimeoutMillis, @Value(value="${config.edu_hub.gateway_url}") URI eduHubGatewayUrl, @Value(value="${config.edu_hub.user}") String eduHubUser, @Value(value="${config.edu_hub.password}") String eduHubPassword, InstitutionRegistry institutionRegistry, QueueService queueService) {
        this.clientUrl = clientUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.secret = secret;
        this.sisUser = sisUser;
        this.sisPassword = sisPassword;
        this.sisResultsEndpoint = sisResultsEndpoint;
        this.institutionRegistry = institutionRegistry;
        this.queueService = queueService;
        this.eduHubGatewayUrl = eduHubGatewayUrl;
        this.eduHubUser = eduHubUser;
        this.eduHubPassword = eduHubPassword;
        this.featureToggles.put("startBrokerEndpoint", startBrokerEndpoint);
        this.featureToggles.put("local", local);
        this.featureToggles.put("allowPlayground", allowPlayground);
        this.featureToggles.put("catalogUrl", catalogUrl);
        this.featureToggles.put("queue", queueService.getBaseUrl());
        this.featureToggles.put("pollEnabled", pollEnabled);
        this.featureToggles.put("surveyEnabled", surveyEnabled);
        this.featureToggles.put("pollSurvey", pollSurvey);
        if (allowPlayground) {
            this.featureToggles.put("playHomeInstitutionSchacHome", playHomeInstitutionSchacHome);
            this.featureToggles.put("playGuestInstitutionSchacHome", playGuestInstitutionSchacHome);
            this.featureToggles.put("offeringId", playOfferingID);
            this.featureToggles.put("alliance", playAlliance);
        }
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)this.getClientHttpRequestFactory(connectionTimeoutMillis));
        this.restTemplate.setInterceptors(Collections.singletonList((request, body, execution) -> {
            request.getHeaders().add("Accept-Language", (String)LanguageFilter.language.get());
            return execution.execute(request, body);
        }));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        String[] denyList = new String[]{"class.*", "Class.*", "*.class.*", "*.Class.*"};
        dataBinder.setDisallowedFields(denyList);
    }

    @PostMapping(value={"/api/broker"}, consumes={"application/x-www-form-urlencoded"})
    public View brokerRequest(HttpServletRequest request, @ModelAttribute BrokerRequest brokerRequest, @RequestParam(value="play", required=false, defaultValue="false") boolean play) throws UnsupportedEncodingException {
        Object queryParams;
        Institution guestInstitution;
        LOG.debug((Object)("Called by the external catalog form submit with BrokerRequest " + String.valueOf(brokerRequest)));
        try {
            brokerRequest.validate();
            this.getInstitution(brokerRequest.getHomeInstitutionSchacHome());
            guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Validation error in the brokerRequest: " + String.valueOf(brokerRequest)), (Throwable)e);
            return new RedirectView(this.clientUrl + "?error=400");
        }
        catch (RemoteException e) {
            LOG.warn((Object)("RemoteException error in the brokerRequest: " + String.valueOf(brokerRequest)), (Throwable)e);
            return new RedirectView(this.clientUrl + "?error=" + e.getStatusCode().value());
        }
        brokerRequest.setUseQueueIt(guestInstitution.isUseQueueIt());
        brokerRequest.setQueueItSucceeded(false);
        request.getSession().setAttribute(BROKER_REQUEST_SESSION_KEY, (Object)brokerRequest);
        LOG.debug((Object)String.format("Started session %s for brokerRequest: %s", request.getSession().getId(), brokerRequest));
        Object object = queryParams = play ? "?step=enroll&name=Johanna&correlationID=1" : "?step=approve";
        if (guestInstitution.isUseQueueIt()) {
            queryParams = (String)queryParams + "&q=" + URLEncoder.encode(this.queueService.getRedirectUrl(guestInstitution), Charset.defaultCharset());
        }
        return new RedirectView(this.clientUrl + (String)queryParams);
    }

    @GetMapping(value={"/api/queue/redirect"})
    public View queueRedirect(HttpServletRequest request, @RequestParam(value="queueittoken") String queueItToken) {
        LOG.debug((Object)("Redirect from queue-it: " + queueItToken));
        BrokerRequest brokerRequest = this.getBrokerRequest(request, false);
        Institution institution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        if (!this.queueService.validateQueueToken(institution, queueItToken)) {
            return new RedirectView(this.clientUrl + "?error=407");
        }
        brokerRequest.setQueueItSucceeded(true);
        request.getSession().setAttribute(BROKER_REQUEST_SESSION_KEY, (Object)brokerRequest);
        return new RedirectView(this.clientUrl + "?step=approve");
    }

    @GetMapping(value={"/api/features"})
    public Map<String, Object> features() {
        LOG.debug((Object)"Received request for feature toggles.");
        return this.featureToggles;
    }

    @GetMapping(value={"/api/offering"})
    public Map<String, Object> offering(HttpServletRequest request) {
        Map offering;
        BrokerRequest brokerRequest = this.getBrokerRequest(request, true);
        LOG.debug((Object)String.format("Received request for offering for brokerRequest %s and session %s", brokerRequest, request.getSession().getId()));
        Institution guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        Institution homeInstitution = this.getInstitution(brokerRequest.getHomeInstitutionSchacHome());
        try {
            offering = this.fetchOffering(guestInstitution, brokerRequest);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Error in fetching offering from " + guestInstitution.getName()), (Throwable)e);
            HttpStatus statusCode = HttpStatus.BAD_REQUEST;
            if (e instanceof HttpClientErrorException) {
                HttpClientErrorException ex = (HttpClientErrorException)e;
                statusCode = ex.getStatusCode();
                LOG.error((Object)("Response error in fetching offering: " + ex.getResponseBodyAsString()), (Throwable)ex);
            }
            RemoteException remoteException = new RemoteException((HttpStatusCode)statusCode, guestInstitution.getName(), (Throwable)e);
            LOG.error((Object)("Reference number for client error correlation: " + remoteException.getReference()));
            throw remoteException;
        }
        request.getSession().setAttribute(OFFERING_SESSION_KEY, (Object)offering);
        EnrollmentRequest enrollmentRequest = new EnrollmentRequest(homeInstitution.getPersonsEndpoint(), homeInstitution.getPersonAuthentication(), homeInstitution.getAssociationsEndpoint(), homeInstitution.getSchacHome(), brokerRequest.getAlliance(), homeInstitution.getScopes());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("guestInstitution", guestInstitution.sanitize());
        result.put("homeInstitution", homeInstitution.sanitize());
        result.put("authenticationActionUrl", guestInstitution.getAuthenticationEndpoint());
        result.put("enrollmentRequest", enrollmentRequest);
        result.put("offering", offering);
        return result;
    }

    private BrokerRequest getBrokerRequest(HttpServletRequest request, boolean validateQueueIt) {
        BrokerRequest brokerRequest = (BrokerRequest)request.getSession().getAttribute(BROKER_REQUEST_SESSION_KEY);
        if (brokerRequest == null) {
            RemoteException remoteException = new RemoteException((HttpStatusCode)HttpStatus.NOT_FOUND, "No broker request in the session");
            LOG.error((Object)("Reference number for client error correlation: " + remoteException.getReference()));
            throw remoteException;
        }
        if (validateQueueIt && brokerRequest.isUseQueueIt() && !brokerRequest.isQueueItSucceeded()) {
            RemoteException remoteException = new RemoteException((HttpStatusCode)HttpStatus.CONFLICT, "QueueIT required but not performed");
            LOG.error((Object)("Reference number for client error correlation: " + remoteException.getReference()));
            throw remoteException;
        }
        return brokerRequest;
    }

    private Institution getInstitution(String institutionSchacHome) {
        LOG.debug((Object)("Lookup institution " + institutionSchacHome + " in serviceregistry."));
        return (Institution)this.institutionRegistry.findInstitutionBySchacHome(institutionSchacHome).orElseThrow(() -> {
            RemoteException remoteException = new RemoteException((HttpStatusCode)HttpStatus.NOT_FOUND, institutionSchacHome);
            LOG.error((Object)String.format("Institution %s unknown with reference number %s", institutionSchacHome, remoteException.getReference()));
            return remoteException;
        });
    }

    @PostMapping(value={"/api/results"})
    public ResponseEntity<Map<String, Object>> results(@RequestBody Map<String, Object> message) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", (String)message.get("correlationID"));
        headers.setBasicAuth(this.sisUser, this.sisPassword);
        return ResponseEntity.ok((Object)this.exchange(this.sisResultsEndpoint, HttpMethod.POST, new HttpEntity(message, (MultiValueMap)headers), new HttpStatus[0]));
    }

    @PostMapping(value={"/api/me"})
    public ResponseEntity<Map<String, Object>> me(@RequestBody Map<String, Object> message) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", (String)message.get("correlationID"));
        headers.setBasicAuth(this.sisUser, this.sisPassword);
        return ResponseEntity.ok((Object)this.exchange(this.sisResultsEndpoint.replace("play-results", "me"), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), new HttpStatus[0]));
    }

    @PostMapping(value={"/api/start"})
    public Map<String, Object> start(HttpServletRequest request, @RequestBody Map<String, String> correlationMap) {
        boolean crossInstitutionRequest;
        BrokerRequest brokerRequest = this.getBrokerRequest(request, true);
        boolean bl = crossInstitutionRequest = !brokerRequest.getHomeInstitutionSchacHome().equals(brokerRequest.getGuestInstitutionSchacHome());
        if (((Boolean)this.featureToggles.get("allowPlayground")).booleanValue() && correlationMap.keySet().stream().anyMatch(s -> s.equals("code"))) {
            LOG.debug((Object)("Returning playground request with parameters: " + String.valueOf(correlationMap)));
            HashMap<String, Object> results = new HashMap<String, Object>(correlationMap);
            results.put("crossInstitutionRequest", (String)((Object)Boolean.valueOf(crossInstitutionRequest)));
            return results;
        }
        Map offering = (Map)request.getSession().getAttribute(OFFERING_SESSION_KEY);
        LOG.debug((Object)String.format("Received start registration request for brokerRequest: %s and session: %s", brokerRequest, request.getSession().getId()));
        try {
            HashMap<String, Object> body = this.doStart(brokerRequest, offering, correlationMap);
            request.getSession().invalidate();
            LOG.debug((Object)String.format("Returning start registration response %s for brokerRequest: %s and session: %s", body, brokerRequest, request.getSession().getId()));
            body = new HashMap<String, Object>(body);
            body.put("crossInstitutionRequest", crossInstitutionRequest);
            return body;
        }
        catch (HttpStatusCodeException | ResourceAccessException e) {
            HttpStatusCode httpStatusCode = e instanceof HttpStatusCodeException ? ((HttpStatusCodeException)e).getStatusCode() : HttpStatusCode.valueOf((int)HttpStatus.REQUEST_TIMEOUT.value());
            RemoteException remoteException = new RemoteException(httpStatusCode, e.getMessage(), e);
            String body = e instanceof HttpStatusCodeException ? ((HttpStatusCodeException)e).getResponseBodyAsString() : e.getMessage();
            LOG.error((Object)String.format("Unexpected exception from /api/start: %s, reference number %s", body, remoteException.getReference()));
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("error", true);
            res.put("code", httpStatusCode.value());
            res.put("reference", remoteException.getReference());
            return res;
        }
    }

    private Map<String, Object> doStart(BrokerRequest brokerRequest, Map<String, Object> offering, Map<String, String> correlationMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Correlation-ID", correlationMap.get("correlationID"));
        headers.setContentType(MediaType.APPLICATION_JSON);
        Institution guestInstitution = this.getInstitution(brokerRequest.getGuestInstitutionSchacHome());
        headers.setBasicAuth(guestInstitution.getRegistrationUser(), guestInstitution.getRegistrationPassword());
        HttpEntity requestEntity = new HttpEntity(offering, (MultiValueMap)headers);
        String url = guestInstitution.getRegistrationEndpoint().toString();
        LOG.debug((Object)String.format("Start registration by POST-ing to %s", url));
        return this.exchange(url, HttpMethod.POST, requestEntity, new HttpStatus[]{HttpStatus.NOT_FOUND});
    }

    protected String translateOfferingType(BrokerRequest brokerRequest) {
        String expandable;
        String type = brokerRequest.getOfferingType();
        String string = expandable = StringUtils.hasText((String)type) ? type.toLowerCase() : "course";
        if (expandable.equals("minor")) {
            expandable = "program";
        }
        return expandable;
    }

    private Map<String, Object> fetchOffering(Institution guestInstitution, BrokerRequest brokerRequest) {
        if (guestInstitution.isUseEduHubForOffering()) {
            String uri = String.format("%s/%s/%s?expand=academicSession,%s", this.eduHubGatewayUrl, "offerings", brokerRequest.getOfferingId(), this.translateOfferingType(brokerRequest));
            HttpHeaders headers = new HttpHeaders();
            headers.setBasicAuth(this.eduHubUser, this.eduHubPassword);
            headers.set("Accept", "application/json;version=5");
            headers.add("X-Route", "endpoint=" + guestInstitution.getSchacHome());
            LOG.debug((Object)("Fetching offering " + uri + " with basic authentication from eduHub"));
            Map body = this.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), new HttpStatus[0]);
            return (Map)((Map)body.get("responses")).get(guestInstitution.getSchacHome());
        }
        String uri = String.format("%s/%s?expand=academicSession,%s", guestInstitution.getCourseEndpoint(), brokerRequest.getOfferingId(), this.translateOfferingType(brokerRequest));
        CourseAuthentication courseAuthentication = guestInstitution.getCourseAuthentication();
        LOG.debug((Object)String.format("Fetching offering from %s with security %s", uri, courseAuthentication.name()));
        if (courseAuthentication.equals((Object)CourseAuthentication.NONE)) {
            LOG.debug((Object)("Fetching offering " + uri + " without authentication"));
            return this.exchange(uri, HttpMethod.GET, null, new HttpStatus[0]);
        }
        if (courseAuthentication.equals((Object)CourseAuthentication.BASIC)) {
            LOG.debug((Object)("Fetching offering " + uri + " with basic authentication"));
            return this.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicAuthHeaders(guestInstitution)), new HttpStatus[0]);
        }
        LOG.debug((Object)("Fetching offering " + uri + " with OAUTH authentication"));
        return this.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.accessTokenHeaders()), new HttpStatus[0]);
    }

    private Map<String, Object> exchange(String uri, HttpMethod method, @Nullable HttpEntity<?> requestEntity, HttpStatus ... ignoreHtpStatusCodes) {
        try {
            return (Map)this.restTemplate.exchange(uri, method, requestEntity, this.mapRef, new Object[0]).getBody();
        }
        catch (HttpClientErrorException e) {
            if (ignoreHtpStatusCodes != null && Arrays.stream(ignoreHtpStatusCodes).anyMatch(httpStatus -> httpStatus.equals((Object)e.getStatusCode()))) {
                LOG.warn((Object)String.format("Error from uri %s with requestEntity %s and response %s", uri, requestEntity, e.getResponseBodyAsString()));
            } else {
                LOG.error((Object)String.format("Error from uri %s with requestEntity %s and response %s", uri, requestEntity, e.getResponseBodyAsString()), (Throwable)e);
            }
            throw e;
        }
    }

    private HttpHeaders basicAuthHeaders(Institution institution) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(institution.getCourseAuthenticationUserName(), institution.getCourseAuthenticationPassword());
        return headers;
    }

    private HttpHeaders accessTokenHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBasicAuth(this.clientId, this.secret);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"scope", (Object)"openid");
        Map result = this.exchange(this.tokenEndpoint.toString(), HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), new HttpStatus[0]);
        String accessToken = (String)result.get("access_token");
        headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", "Bearer " + accessToken);
        return headers;
    }

    private SimpleClientHttpRequestFactory getClientHttpRequestFactory(int connectionTimeoutMillis) {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(connectionTimeoutMillis);
        clientHttpRequestFactory.setReadTimeout(connectionTimeoutMillis);
        return clientHttpRequestFactory;
    }
}

