/*
 * Decompiled with CFR 0.152.
 */
package broker.mail;

import broker.domain.PollRequest;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import jakarta.mail.internet.MimeMessage;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailBox {
    private final JavaMailSender mailSender;
    private final String emailFrom;
    private final String pollEmail;
    private final String environment;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory("templates");

    public MailBox(JavaMailSender mailSender, String emailFrom, String pollEmail, String environment) {
        this.mailSender = mailSender;
        this.emailFrom = emailFrom;
        this.pollEmail = pollEmail;
        this.environment = environment;
    }

    public void sendPollMail(PollRequest pollRequest) {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        variables.put("pollRequest", (String)pollRequest);
        this.sendMail("poll_en", "Poll result", variables, new String[]{this.pollEmail});
    }

    private String sendMail(String templateName, String subject, Map<String, Object> variables, String ... to) {
        String htmlText = this.mailTemplate(templateName + ".html", variables);
        String plainText = this.mailTemplate(templateName + ".txt", variables);
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        helper.setSubject(subject);
        helper.setText(plainText, htmlText);
        helper.setTo(to);
        helper.setFrom(this.emailFrom);
        new Thread(() -> this.mailSender.send(mimeMessage)).start();
        return htmlText;
    }

    private String mailTemplate(String templateName, Map<String, Object> context) {
        return this.mustacheFactory.compile(templateName).execute((Writer)new StringWriter(), context).toString();
    }
}

