/*
 * Decompiled with CFR 0.152.
 */
package broker.domain;

import broker.domain.CourseAuthentication;
import broker.domain.PersonAuthentication;
import java.io.Serializable;
import java.net.URI;
import lombok.Generated;
import org.springframework.util.Assert;

public class Institution
implements Serializable {
    private String schacHome;
    private String name;
    private String abbreviation;
    private URI authenticationEndpoint;
    private URI courseEndpoint;
    private URI privacyEndpoint;
    private String personsEndpoint;
    private PersonAuthentication personAuthentication;
    private String associationsEndpoint;
    private URI registrationEndpoint;
    private String registrationUser;
    private String registrationPassword;
    private URI logoURI;
    private String supportLink;
    private String scopes;
    private CourseAuthentication courseAuthentication;
    private String courseAuthenticationUserName;
    private String courseAuthenticationPassword;
    private boolean useEduHubForOffering;
    private boolean useQueueIt;
    private String queueItWaitingRoom;
    private String queueItSecret;

    public void validate() {
        Assert.notNull((Object)this.courseAuthentication, (String)"courseAuthentication is required");
        if (this.courseAuthentication.equals((Object)CourseAuthentication.BASIC)) {
            Assert.notNull((Object)this.courseAuthenticationUserName, (String)"courseAuthenticationUserName is required for BASIC authentication");
            Assert.notNull((Object)this.courseAuthenticationPassword, (String)"courseAuthenticationPassword is required for BASIC authentication");
        }
        Assert.notNull((Object)this.name, (String)"name is required");
        Assert.notNull((Object)this.abbreviation, (String)"abbreviation is required");
        Assert.notNull((Object)this.courseEndpoint, (String)"courseEndpoint is required");
        Assert.notNull((Object)this.personsEndpoint, (String)"personsEndpoint is required");
        Assert.notNull((Object)this.personAuthentication, (String)"personAuthentication is required");
        Assert.notNull((Object)this.associationsEndpoint, (String)"associationsEndpoint is required");
        Assert.notNull((Object)this.authenticationEndpoint, (String)"authenticationEndpoint is required");
        Assert.notNull((Object)this.registrationEndpoint, (String)"registrationEndpoint is required");
        Assert.notNull((Object)this.registrationUser, (String)"registrationUser is required");
        Assert.notNull((Object)this.registrationPassword, (String)"registrationPassword is required");
        Assert.notNull((Object)this.logoURI, (String)"logoURI is required");
        Assert.notNull((Object)this.scopes, (String)"scopes is required");
        Assert.notNull((Object)this.privacyEndpoint, (String)"privacyEndpoint is required");
        if (this.useQueueIt) {
            Assert.hasLength((String)this.queueItWaitingRoom, (String)"If queueIt is enabled, then specify the queueItWaitingRoom");
            Assert.isTrue((boolean)this.queueItWaitingRoom.matches("[a-zA-Z0-9]+"), (String)"queueItWaitingRoom may only contain letters");
            Assert.hasLength((String)this.queueItSecret, (String)"If queueIt is enabled, then specify the queueItWaitingRoom");
        }
    }

    public Institution(boolean useQueueIt, String queueItWaitingRoom, String queueItSecret) {
        this.useQueueIt = useQueueIt;
        this.queueItWaitingRoom = queueItWaitingRoom;
        this.queueItSecret = queueItSecret;
    }

    public Institution sanitize() {
        Institution institution = new Institution();
        institution.schacHome = this.schacHome;
        institution.name = this.name;
        institution.logoURI = this.logoURI;
        institution.supportLink = this.supportLink;
        institution.privacyEndpoint = this.privacyEndpoint;
        institution.abbreviation = this.abbreviation;
        institution.courseEndpoint = this.courseEndpoint;
        institution.courseAuthentication = this.courseAuthentication;
        institution.scopes = this.scopes;
        return institution;
    }

    @Generated
    public String getSchacHome() {
        return this.schacHome;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Generated
    public URI getAuthenticationEndpoint() {
        return this.authenticationEndpoint;
    }

    @Generated
    public URI getCourseEndpoint() {
        return this.courseEndpoint;
    }

    @Generated
    public URI getPrivacyEndpoint() {
        return this.privacyEndpoint;
    }

    @Generated
    public String getPersonsEndpoint() {
        return this.personsEndpoint;
    }

    @Generated
    public PersonAuthentication getPersonAuthentication() {
        return this.personAuthentication;
    }

    @Generated
    public String getAssociationsEndpoint() {
        return this.associationsEndpoint;
    }

    @Generated
    public URI getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    @Generated
    public String getRegistrationUser() {
        return this.registrationUser;
    }

    @Generated
    public String getRegistrationPassword() {
        return this.registrationPassword;
    }

    @Generated
    public URI getLogoURI() {
        return this.logoURI;
    }

    @Generated
    public String getSupportLink() {
        return this.supportLink;
    }

    @Generated
    public String getScopes() {
        return this.scopes;
    }

    @Generated
    public CourseAuthentication getCourseAuthentication() {
        return this.courseAuthentication;
    }

    @Generated
    public String getCourseAuthenticationUserName() {
        return this.courseAuthenticationUserName;
    }

    @Generated
    public String getCourseAuthenticationPassword() {
        return this.courseAuthenticationPassword;
    }

    @Generated
    public boolean isUseEduHubForOffering() {
        return this.useEduHubForOffering;
    }

    @Generated
    public boolean isUseQueueIt() {
        return this.useQueueIt;
    }

    @Generated
    public String getQueueItWaitingRoom() {
        return this.queueItWaitingRoom;
    }

    @Generated
    public String getQueueItSecret() {
        return this.queueItSecret;
    }

    @Generated
    public Institution() {
    }
}

