/*
 * Decompiled with CFR 0.152.
 */
package home.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import home.api.AbstractDelayEndpoint;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PersonEndpoint
extends AbstractDelayEndpoint {
    private static final Log LOG = LogFactory.getLog(PersonEndpoint.class);
    private final ObjectMapper objectMapper;

    public PersonEndpoint(ObjectMapper objectMapper, @Value(value="${delay.enabled}") boolean delayEnabled, @Value(value="${delay.millis-person}") long delayMillis) {
        super(delayEnabled, delayMillis);
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/persons/me"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> personGet(BearerTokenAuthentication authentication) throws IOException {
        return this.doPerson(authentication);
    }

    @PostMapping(value={"/persons/me"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> personPost(BearerTokenAuthentication authentication) throws IOException {
        return this.doPerson(authentication);
    }

    private ResponseEntity<Map<String, Object>> doPerson(BearerTokenAuthentication authentication) throws IOException {
        this.delayResponse();
        Map map = (Map)this.objectMapper.readValue(new ClassPathResource("/data/person.json").getInputStream(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        Map tokenAttributes = authentication.getTokenAttributes();
        String eppn = (String)tokenAttributes.get("eduperson_principal_name");
        String sub = (String)tokenAttributes.get("sub");
        String givenName = (String)tokenAttributes.get("given_name");
        String familyName = (String)tokenAttributes.get("family_name");
        String mail = (String)tokenAttributes.get("email");
        LOG.debug((Object)String.format("Persons request for eppn: %s, sub: %s, mail: %s", eppn, sub, mail));
        if (StringUtils.hasText((String)eppn)) {
            map.put("personId", eppn);
        }
        if (StringUtils.hasText((String)mail)) {
            map.put("mail", mail);
        }
        if (StringUtils.hasText((String)givenName)) {
            map.put("givenName", givenName);
        }
        if (StringUtils.hasText((String)familyName)) {
            map.put("surname", familyName);
        }
        if (StringUtils.hasText((String)givenName) && StringUtils.hasText((String)familyName)) {
            map.put("displayName", String.format("%s %s", givenName, familyName));
        }
        LOG.info((Object)("Returning in person endpoint for " + eppn));
        return ResponseEntity.ok((Object)map);
    }
}

