/*
 * Decompiled with CFR 0.152.
 */
package home;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {

    @Order
    @Configuration
    public static class BasicSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${security.user.name}")
        private String user;
        @Value(value="${security.user.password}")
        private String password;

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            auth.inMemoryAuthentication().withUser(this.user).password(String.format("{noop}%s", this.password)).authorities(new String[]{"ROLE_USER"});
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/basic/offerings/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).addFilterBefore((Filter)new BasicAuthenticationFilter(this.authenticationManager()), BasicAuthenticationFilter.class).authorizeRequests().antMatchers(new String[]{"/**"})).hasRole("USER");
        }
    }

    @Order(value=1)
    @Configuration
    public static class OAuth2SecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            DefaultBearerTokenResolver tokenResolver = new DefaultBearerTokenResolver();
            tokenResolver.setAllowFormEncodedBodyParameter(true);
            ((HttpSecurity)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/persons/**", "/associations/**", "/oauth2/offerings/**"})).and().authorizeRequests(authz -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authz.antMatchers(HttpMethod.GET)).hasAuthority("SCOPE_openid").anyRequest()).authenticated()).sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf().disable()).oauth2ResourceServer().bearerTokenResolver((BearerTokenResolver)tokenResolver).opaqueToken();
        }
    }
}

