/*
 * Decompiled with CFR 0.152.
 */
package home.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import home.api.AbstractDelayEndpoint;
import home.mail.MailBox;
import home.model.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AssociationEndpoint
extends AbstractDelayEndpoint {
    private static final Log LOG = LogFactory.getLog(AssociationEndpoint.class);
    private final MailBox mailBox;
    private final ObjectMapper objectMapper;
    private final String[] statuses = new String[]{"pending", "canceled", "denied", "associated"};
    private final Random random = new Random();

    public AssociationEndpoint(MailBox mailBox, ObjectMapper objectMapper, @Value(value="${delay.enabled}") boolean delayEnabled, @Value(value="${delay.millis-association}") long delayMillis) {
        super(delayEnabled, delayMillis);
        this.mailBox = mailBox;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/associations/{associationId}"})
    public ResponseEntity<Map<String, Object>> getAssociation(BearerTokenAuthentication authentication, @PathVariable(value="associationId") String associationId) throws IOException {
        this.delayResponse();
        User user = new User(authentication.getTokenAttributes());
        LOG.debug((Object)String.format("Associations GET request for person eppn %s and eduid %s for associationId %s", user.getEppn(), user.getEduid(), associationId));
        Map map = (Map)this.objectMapper.readValue(new ClassPathResource("/data/association.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        map.put("associationId", associationId);
        this.addRandomState(map);
        return ResponseEntity.ok((Object)map);
    }

    @PostMapping(value={"/associations/external/me"})
    public ResponseEntity<Map<String, Object>> newAssociation(BearerTokenAuthentication authentication, @RequestBody Map<String, Object> offeringAssociation) throws IOException, MessagingException {
        this.delayResponse();
        User user = new User(authentication.getTokenAttributes());
        LOG.debug((Object)String.format("Associations PATCH request for person eppn %s and eduid %s with result %s", user.getEppn(), user.getEduid(), offeringAssociation));
        this.mailBox.sendNewAssociation(String.format("%s %s", user.getGivenName(), user.getFamilyName()), user.getEmail(), this.objectMapper.writeValueAsString(offeringAssociation));
        Map map = (Map)this.objectMapper.readValue(new ClassPathResource("/data/association.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        map.put("associationId", UUID.randomUUID().toString());
        this.addRandomState(map);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)map);
    }

    @PatchMapping(value={"/associations/{associationId}"})
    public ResponseEntity<Map<String, Object>> associationUpdate(BearerTokenAuthentication authentication, @PathVariable(value="associationId") String associationId, @RequestBody Map<String, Object> resultsMap) throws IOException, MessagingException {
        this.delayResponse();
        User user = new User(authentication.getTokenAttributes());
        LOG.debug((Object)String.format("Associations PATCH request for person eppn %s and eduid %s with result %s", user.getEppn(), user.getEduid(), resultsMap));
        this.mailBox.sendUserAssociation(String.format("%s %s", user.getGivenName(), user.getFamilyName()), user.getEmail(), this.objectMapper.writeValueAsString(resultsMap));
        Map map = (Map)this.objectMapper.readValue(new ClassPathResource("/data/association.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        map.put("associationId", associationId);
        this.addRandomState(map);
        return ResponseEntity.ok((Object)map);
    }

    @PostMapping(value={"/associations/me"})
    public ResponseEntity<Map<String, Object>> results(BearerTokenAuthentication authentication, @RequestBody Map<String, Object> resultsMap) throws JsonProcessingException, MessagingException {
        this.delayResponse();
        User user = new User(authentication.getTokenAttributes());
        LOG.debug((Object)String.format("Associations POST request for person eppn %s and eduid %s with result %s", user.getEppn(), user.getEduid(), resultsMap));
        this.mailBox.sendUserResults(String.format("%s %s", user.getGivenName(), user.getFamilyName()), user.getEmail(), this.objectMapper.writeValueAsString(resultsMap));
        return ResponseEntity.ok(Collections.singletonMap("res", "ok"));
    }

    private void addRandomState(Map<String, Object> map) {
        String randomStatus = this.statuses[this.random.nextInt(this.statuses.length)];
        map.put("state", randomStatus);
        ArrayList messages = new ArrayList();
        HashMap<String, String> messageDetails = new HashMap<String, String>();
        messageDetails.put("language", "en-GB");
        messageDetails.put("value", "This is just a random state, since this is a demo only.");
        messages.add(messageDetails);
        map.put("message", messages);
    }
}

