/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar;

import com.tapstream.rollbar.HttpRequest;
import com.tapstream.rollbar.IHttpRequester;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpRequester
implements IHttpRequester {
    private int timeout = 5000;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(HttpRequest request) throws IOException {
        URL url = request.getUrl();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod(request.getMethod());
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
            for (Map.Entry<String, String> pair : request.getHeaders().entrySet()) {
                connection.setRequestProperty(pair.getKey(), pair.getValue());
            }
            byte[] body = request.getBody();
            if (body != null) {
                connection.setDoOutput(true);
                this.writeBody(body, connection);
            }
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void writeBody(byte[] body, HttpURLConnection connection) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());){
            ((OutputStream)out).write(body);
        }
    }
}

