/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar;

import com.tapstream.rollbar.NotifierDataProvider;
import com.tapstream.rollbar.RollbarException;
import com.tapstream.rollbar.ServerDataProvider;
import com.tapstream.rollbar.fingerprinter.Fingerprinter;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyBuilder {
    private static final String PERSON_PREFIX = "person.";
    private final String accessToken;
    private final String environment;
    private final JSONObject notifierData;
    private final JSONObject serverData;
    private final Fingerprinter fingerprinter;

    public NotifyBuilder(String accessToken, String environment, ServerDataProvider serverDataProvider, NotifierDataProvider notifierDataProvider, Fingerprinter fingerprinter) throws JSONException, RollbarException {
        this.accessToken = accessToken;
        this.environment = environment;
        this.notifierData = notifierDataProvider.getNotifierData();
        this.serverData = serverDataProvider.getServerData();
        this.fingerprinter = fingerprinter;
    }

    private String getValue(String key, Map<String, String> context, String defaultValue) {
        if (context == null) {
            return defaultValue;
        }
        String value = context.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public JSONObject build(String level, String message, Throwable throwable, Map<String, String> context, String loggerName) throws JSONException {
        JSONObject person;
        JSONObject payload = new JSONObject();
        payload.put("access_token", (Object)this.accessToken);
        JSONObject data = new JSONObject();
        this.maybeAddFingerprint(message, throwable, context, loggerName, data);
        data.put("environment", (Object)this.environment);
        data.put("level", (Object)level);
        data.put("platform", (Object)this.getValue("platform", context, "java"));
        data.put("framework", (Object)this.getValue("framework", context, "java"));
        data.put("language", (Object)"java");
        if (loggerName != null && !loggerName.isEmpty()) {
            data.put("context", (Object)loggerName);
        }
        data.put("timestamp", System.currentTimeMillis() / 1000L);
        data.put("body", (Object)this.getBody(message, throwable));
        data.put("request", (Object)this.buildRequest(context));
        JSONObject customData = this.buildCustom(context);
        if (throwable != null && message != null) {
            customData.put("log", (Object)message);
        }
        if ((person = this.buildPerson(context)) != null) {
            data.put("person", (Object)person);
        }
        data.put("custom", (Object)customData);
        data.put("client", (Object)this.buildClient(context));
        data.put("server", (Object)this.serverData);
        data.put("notifier", (Object)this.notifierData);
        payload.put("data", (Object)data);
        return payload;
    }

    private void maybeAddFingerprint(String message, Throwable throwable, Map<String, String> context, String loggerName, JSONObject payload) {
        if (this.fingerprinter == null) {
            return;
        }
        String fingerprint = this.fingerprinter.fingerprint(message, throwable, context, loggerName);
        if (fingerprint != null) {
            payload.put("fingerprint", (Object)fingerprint);
        }
    }

    private JSONObject buildPerson(Map<String, String> ctx) {
        JSONObject person = new JSONObject();
        for (Map.Entry<String, String> ctxEntry : ctx.entrySet()) {
            String key = ctxEntry.getKey();
            if (!key.startsWith(PERSON_PREFIX)) continue;
            person.put(this.stripPrefix(key, PERSON_PREFIX), (Object)ctxEntry.getValue());
        }
        if (person.keySet().isEmpty()) {
            return null;
        }
        return person;
    }

    private JSONObject buildClient(Map<String, String> ctx) {
        JSONObject client = new JSONObject();
        JSONObject javaScript = new JSONObject();
        javaScript.put("browser", (Object)ctx.get("request.user_agent"));
        client.put("javascript", (Object)javaScript);
        return client;
    }

    private JSONObject buildCustom(Map<String, String> ctx) {
        JSONObject custom = new JSONObject();
        for (Map.Entry<String, String> ctxEntry : ctx.entrySet()) {
            String key = ctxEntry.getKey();
            if (key.startsWith("request.") || key.startsWith(PERSON_PREFIX)) continue;
            custom.put(key, (Object)ctxEntry.getValue());
        }
        return custom;
    }

    private String stripPrefix(String value, String prefix) {
        return value.substring(prefix.length(), value.length());
    }

    private JSONObject buildRequest(Map<String, String> ctx) {
        JSONObject request = new JSONObject();
        request.put("url", (Object)ctx.get("request.url"));
        request.put("query_string", (Object)ctx.get("request.qs"));
        JSONObject headers = new JSONObject();
        JSONObject params = new JSONObject();
        for (Map.Entry<String, String> ctxEntry : ctx.entrySet()) {
            String key = ctxEntry.getKey();
            if (key.startsWith("request.header.")) {
                headers.put(this.stripPrefix(key, "request.header."), (Object)ctxEntry.getValue());
                continue;
            }
            if (!key.startsWith("request.param.")) continue;
            params.put(this.stripPrefix(key, "request.param."), (Object)ctxEntry.getValue());
        }
        request.put("headers", (Object)headers);
        String method = ctx.get("request.method");
        if (method != null) {
            request.put("method", (Object)method);
            request.put(method, (Object)params);
        }
        request.put("user_ip", (Object)ctx.get("request.remote_addr"));
        return request;
    }

    private JSONObject getBody(String message, Throwable original) throws JSONException {
        JSONObject body = new JSONObject();
        Throwable throwable = original;
        if (throwable != null) {
            ArrayList<JSONObject> traces = new ArrayList<JSONObject>();
            do {
                traces.add(0, this.createTrace(throwable));
            } while ((throwable = throwable.getCause()) != null);
            body.put("trace_chain", (Object)new JSONArray(traces));
        }
        if (original == null && message != null) {
            JSONObject messageBody = new JSONObject();
            messageBody.put("body", (Object)message);
            body.put("message", (Object)messageBody);
        }
        return body;
    }

    private JSONObject createTrace(Throwable throwable) throws JSONException {
        JSONObject trace = new JSONObject();
        JSONArray frames = new JSONArray();
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = elements.length - 1; i >= 0; --i) {
            StackTraceElement element = elements[i];
            JSONObject frame = new JSONObject();
            frame.put("class_name", (Object)element.getClassName());
            frame.put("filename", (Object)element.getFileName());
            frame.put("method", (Object)element.getMethodName());
            if (element.getLineNumber() > 0) {
                frame.put("lineno", element.getLineNumber());
            }
            frames.put((Object)frame);
        }
        JSONObject exceptionData = new JSONObject();
        exceptionData.put("class", (Object)throwable.getClass().getName());
        exceptionData.put("message", (Object)throwable.getMessage());
        trace.put("frames", (Object)frames);
        trace.put("exception", (Object)exceptionData);
        return trace;
    }
}

