/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.tapstream.rollbar.HttpRequest;
import com.tapstream.rollbar.HttpRequester;
import com.tapstream.rollbar.IHttpRequester;
import com.tapstream.rollbar.NotifierDataProvider;
import com.tapstream.rollbar.NotifyBuilder;
import com.tapstream.rollbar.RollbarException;
import com.tapstream.rollbar.ServerDataProvider;
import com.tapstream.rollbar.fingerprinter.DefaultFingerprinter;
import com.tapstream.rollbar.fingerprinter.Fingerprinter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RollbarAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private NotifyBuilder payloadBuilder;
    private URL url;
    private String apiKey;
    private String environment;
    private boolean async = true;
    private IHttpRequester httpRequester = new HttpRequester();
    private Fingerprinter fingerprinter = new DefaultFingerprinter();

    public RollbarAppender() {
        try {
            this.url = new URL("https://api.rollbar.com/api/1/item/");
        }
        catch (MalformedURLException e) {
            this.addError("Error initializing url", e);
        }
    }

    public void setHttpRequester(IHttpRequester httpRequester) {
        this.httpRequester = httpRequester;
    }

    public void setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.addError("Error setting url", e);
        }
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void start() {
        boolean error = false;
        if (this.url == null) {
            this.addError("No url set for the appender named [" + this.getName() + "].");
            error = true;
        }
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("No apiKey set for the appender named [" + this.getName() + "].");
            error = true;
        }
        if (this.environment == null || this.environment.isEmpty()) {
            this.addError("No environment set for the appender named [" + this.getName() + "].");
            error = true;
        }
        try {
            this.payloadBuilder = new NotifyBuilder(this.apiKey, this.environment, new ServerDataProvider(), new NotifierDataProvider(), this.fingerprinter);
        }
        catch (RollbarException | JSONException e) {
            this.addError("Error building NotifyBuilder", e);
            error = true;
        }
        if (!error) {
            super.start();
        }
    }

    public void stop() {
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        String levelName = event.getLevel().toString().toLowerCase();
        String message = event.getFormattedMessage();
        Map propertyMap = event.getMDCPropertyMap();
        Throwable throwable = null;
        ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
        if (throwableProxy != null) {
            throwable = throwableProxy.getThrowable();
        }
        String loggerName = event.getLoggerName();
        JSONObject payload = this.payloadBuilder.build(levelName, message, throwable, propertyMap, loggerName);
        final HttpRequest request = new HttpRequest(this.url, "POST");
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Accept", "application/json");
        request.setBody(payload.toString());
        if (this.async) {
            this.getContext().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    RollbarAppender.this.sendRequest(request);
                }
            });
        } else {
            this.sendRequest(request);
        }
    }

    private void sendRequest(HttpRequest request) {
        try {
            int statusCode = this.httpRequester.send(request);
            if (statusCode < 200 || statusCode > 299) {
                this.addError("Non-2xx response from Rollbar: " + statusCode);
            }
        }
        catch (IOException e) {
            this.addError("Exception sending request to Rollbar", e);
        }
    }

    public void setFingerprinter(Fingerprinter fingerprinter) {
        this.fingerprinter = fingerprinter;
    }
}

