/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar;

import com.tapstream.rollbar.sanitize.HeaderSanitizer;
import com.tapstream.rollbar.sanitize.NoOpHeaderSanitizer;
import com.tapstream.rollbar.sanitize.SanitizedHttpRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class RollbarFilter
implements Filter {
    public static final String REQUEST_PREFIX = "request.";
    public static final String REQUEST_REMOTE_ADDR = "request.remote_addr";
    public static final String REQUEST_URL = "request.url";
    public static final String REQUEST_QS = "request.qs";
    public static final String REQUEST_METHOD = "request.method";
    public static final String REQUEST_USER_AGENT = "request.user_agent";
    public static final String REQUEST_HEADER_PREFIX = "request.header.";
    public static final String REQUEST_PARAM_PREFIX = "request.param.";
    private final HeaderSanitizer headerSanitizer;

    public RollbarFilter() {
        this(new NoOpHeaderSanitizer());
    }

    public RollbarFilter(HeaderSanitizer headerSanitizer) {
        Objects.requireNonNull(headerSanitizer);
        this.headerSanitizer = headerSanitizer;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Map<String, String> details = this.collectDetails(servletRequest);
        this.putToMDC(details);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.clearMDC(details);
        }
    }

    Map<String, String> collectDetails(ServletRequest request) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put(REQUEST_REMOTE_ADDR, request.getRemoteAddr());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            this.collectHttpDetails((HttpServletRequest)new SanitizedHttpRequest(httpRequest, this.headerSanitizer), details);
        }
        return details;
    }

    private void collectHttpDetails(HttpServletRequest httpRequest, Map<String, String> details) {
        String requestUrl = Objects.toString(httpRequest.getRequestURL(), null);
        if (requestUrl != null) {
            details.put(REQUEST_URL, requestUrl);
        }
        details.put(REQUEST_QS, httpRequest.getQueryString());
        details.put(REQUEST_METHOD, httpRequest.getMethod());
        details.put(REQUEST_USER_AGENT, httpRequest.getHeader("User-Agent"));
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = httpRequest.getHeader(headerName);
            details.put(REQUEST_HEADER_PREFIX + headerName, headerValue);
        }
        Enumeration paramNames = httpRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = httpRequest.getParameter(paramName);
            details.put(REQUEST_PARAM_PREFIX + paramName, paramValue);
        }
    }

    void putToMDC(Map<String, String> details) {
        for (Map.Entry<String, String> entry : details.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void clearMDC(Map<String, String> details) {
        for (String key : details.keySet()) {
            MDC.remove((String)key);
        }
    }

    public void destroy() {
    }
}

