/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar.fingerprinter;

import com.tapstream.rollbar.fingerprinter.Fingerprinter;
import com.tapstream.rollbar.fingerprinter.HasFingerprint;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class CustomFingerprinter
implements Fingerprinter {
    private static final String NUMBER = "\\d+";
    private static final int MAX_CAUSES = 100;

    @Override
    public String fingerprint(String message, Throwable throwable, Map<String, String> context, String loggerName) {
        if (message == null && throwable == null) {
            return null;
        }
        MessageDigest digest = this.getDigest();
        if (throwable != null) {
            this.fingerprintThrowable(throwable, digest);
        } else if (message != null) {
            this.fingerprintMessage(message, digest);
        }
        return new String(Hex.encodeHex((byte[])digest.digest()));
    }

    protected void fingerprintMessage(String message, MessageDigest digest) {
        digest.update(message.replaceAll(NUMBER, "").getBytes());
    }

    protected void fingerprintThrowable(Throwable throwable, MessageDigest digest) {
        Throwable current = throwable;
        for (int depth = 0; current != null && depth < 100; current = current.getCause(), ++depth) {
            digest.update(current.getClass().getName().getBytes());
            this.appendHasFingerprint(digest, current);
            this.appendStacktrace(digest, current);
        }
    }

    protected void appendStacktrace(MessageDigest digest, Throwable current) {
        if (current.getStackTrace() != null) {
            for (StackTraceElement ste : current.getStackTrace()) {
                this.appendStacktraceElement(digest, ste);
            }
        }
    }

    protected void appendStacktraceElement(MessageDigest digest, StackTraceElement ste) {
        String className = ste.getClassName().replaceAll(NUMBER, "");
        digest.update(className.getBytes());
        String methodName = ste.getMethodName().replaceAll(NUMBER, "");
        digest.update(methodName.getBytes());
    }

    protected void appendHasFingerprint(MessageDigest digest, Throwable current) {
        String partialFingerprint;
        if (current instanceof HasFingerprint && (partialFingerprint = ((HasFingerprint)((Object)current)).getFingerprint()) != null) {
            digest.update(partialFingerprint.getBytes());
        }
    }

    protected MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to initialize MD5", e);
        }
    }
}

