/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar.fingerprinter;

import com.tapstream.rollbar.fingerprinter.CustomFingerprinter;
import com.tapstream.rollbar.fingerprinter.Fingerprinter;
import com.tapstream.rollbar.fingerprinter.HasFingerprint;
import java.util.Map;

public class DefaultFingerprinter
implements Fingerprinter {
    private static final int MAX_CAUSES = 100;
    private final CustomFingerprinter customFingerprinter;

    public DefaultFingerprinter() {
        this.customFingerprinter = new CustomFingerprinter();
    }

    DefaultFingerprinter(CustomFingerprinter fingerprinter) {
        this.customFingerprinter = fingerprinter;
    }

    @Override
    public String fingerprint(String message, Throwable throwable, Map<String, String> context, String loggerName) {
        if (this.prividesCustomFingerprint(throwable)) {
            return this.customFingerprinter.fingerprint(message, throwable, context, loggerName);
        }
        return null;
    }

    private boolean prividesCustomFingerprint(Throwable throwable) {
        if (throwable != null) {
            Throwable current = throwable;
            for (int depth = 0; current != null && depth < 100; current = current.getCause(), ++depth) {
                if (!(current instanceof HasFingerprint)) continue;
                return true;
            }
        }
        return false;
    }
}

