/*
 * Decompiled with CFR 0.152.
 */
package com.tapstream.rollbar.sanitize;

import com.tapstream.rollbar.sanitize.HeaderSanitizer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class SanitizedHttpRequest
extends HttpServletRequestWrapper {
    private final HeaderSanitizer headerSanitizer;
    private final Map<String, String> sanitizedHeaders;
    private final HttpServletRequest originalRequest;

    public SanitizedHttpRequest(HttpServletRequest request, HeaderSanitizer headerSanitizer) {
        super(request);
        this.originalRequest = request;
        this.headerSanitizer = headerSanitizer;
        this.sanitizedHeaders = this.sanitizeHeaders();
    }

    public String getHeader(String name) {
        return this.sanitizedHeaders.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.sanitizedHeaders.keySet());
    }

    private Map<String, String> sanitizeHeaders() {
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        Enumeration headerNames = this.originalRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            this.sanitizeHeader(name, this.originalRequest.getHeader(name), newHeaders);
        }
        return newHeaders;
    }

    private void sanitizeHeader(String name, String originalValue, Map<String, String> newHeaders) {
        String value = this.headerSanitizer.sanitize(name, originalValue);
        if (value != null) {
            newHeaders.put(name, value);
        }
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getHeaders(String name) {
        throw new UnsupportedOperationException();
    }

    public int getIntHeader(String name) {
        throw new UnsupportedOperationException();
    }
}

