/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 7;

    DateAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        this.init(stmt, 12, 12, form, forBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    DateAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, 12, 12, form, false);
        this.initForDescribe(12, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeMaxLength = 7;
        if (max_len > 0 && max_len < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = max_len;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int currentRow) throws SQLException {
        String result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            int off = this.columnIndex + this.byteLength * currentRow;
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            result = year + "-" + DateAccessor.toStr(this.rowSpaceByte[2 + off]) + "-" + DateAccessor.toStr(this.rowSpaceByte[3 + off]) + " " + DateAccessor.toStr(this.rowSpaceByte[4 + off] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[5 + off] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[6 + off] - 1) + ".0";
        }
        return result;
    }

    Object getObject(int currentRow) throws SQLException {
        Date result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            if (this.externalType == 0) {
                result = this.statement.connection.v8Compatible ? this.getTimestamp(currentRow) : this.getDate(currentRow);
            } else {
                switch (this.externalType) {
                    case 91: {
                        return this.getDate(currentRow);
                    }
                    case 92: {
                        return this.getTime(currentRow);
                    }
                    case 93: {
                        return this.getTimestamp(currentRow);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return result;
    }

    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getDATE(currentRow);
    }

    Object getObject(int currentRow, Map map) throws SQLException {
        return this.getObject(currentRow);
    }

    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        if (!this.statement.connection.v8Compatible || this.externalType != 93) {
            return super.getTIMESTAMP(currentRow);
        }
        TIMESTAMP result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int off = this.columnIndex + this.byteLength * currentRow;
            byte[] data = new byte[len];
            System.arraycopy(this.rowSpaceByte, off, data, 0, len);
            result = new TIMESTAMP(data);
        }
        return result;
    }

    static String toStr(int x) {
        return x < 10 ? "0" + x : Integer.toString(x);
    }
}

