/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;

public class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:05_PST_2008";

    protected LRUStatementCache(int size) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "LRUStatementCache(" + size + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (size < 0) {
            DatabaseError.throwSqlException(123);
        }
        this.cacheSize = size;
        this.numElements = 0;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.implicitCacheEnabled = false;
        this.explicitCacheEnabled = false;
    }

    protected void resize(int newSize) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "resize(" + newSize + ") entry", this);
            OracleLog.recursiveTrace = false;
        }
        if (newSize < 0) {
            DatabaseError.throwSqlException(123);
        }
        if (newSize >= this.cacheSize || newSize >= this.numElements) {
            this.cacheSize = newSize;
        } else {
            OracleStatementCacheEntry e = this.applicationCacheEnd;
            while (this.numElements > newSize) {
                this.purgeCacheEntry(e);
                e = e.applicationPrev;
            }
            this.cacheSize = newSize;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "resize(" + newSize + ") exit", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "setImplicitCachingEnabled(" + cache + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (!cache) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = cache;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "getImplicitCachingEnabled(), returning " + retValue, this);
            OracleLog.recursiveTrace = false;
        }
        return retValue;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "setExplicitCachingEnabled(" + cache + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (!cache) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = cache;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "getExplicitCachingEnabled(), returning " + retValue, this);
            OracleLog.recursiveTrace = false;
        }
        return retValue;
    }

    protected void addToImplicitCache(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "addToImplicitCache(" + sql + ", " + statementType + ", " + scrollType + ") entry", this);
            OracleLog.recursiveTrace = false;
        }
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "implicit caching not enabled or already cached, returning...", this);
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        stmt.enterImplicitCache();
        OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
        entry.statement = stmt;
        entry.onImplicit = true;
        entry.sql = sql;
        entry.statementType = statementType;
        entry.scrollType = scrollType;
        entry.applicationNext = this.applicationCacheStart;
        entry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = entry;
        }
        this.applicationCacheStart = entry;
        entry.implicitNext = this.implicitCacheStart;
        entry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = entry;
        }
        this.implicitCacheStart = entry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = entry;
        }
        ++this.numElements;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "addToImplicitCache : return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    protected void addToExplicitCache(OraclePreparedStatement stmt, String key) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "addToExplicitCache(" + key + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (!this.explicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "explicit caching not enabled or already cached, returning...", this);
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        stmt.enterExplicitCache();
        OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
        entry.statement = stmt;
        entry.sql = key;
        entry.onImplicit = false;
        entry.applicationNext = this.applicationCacheStart;
        entry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = entry;
        }
        this.applicationCacheStart = entry;
        entry.explicitNext = this.explicitCacheStart;
        entry.explicitPrev = null;
        if (this.explicitCacheStart != null) {
            this.explicitCacheStart.explicitPrev = entry;
        }
        this.explicitCacheStart = entry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = entry;
        }
        ++this.numElements;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "addToExplicitCache : return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    protected OracleStatement searchImplicitCache(String sql, int statementType, int scrollType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "searchImplicitCache(" + sql + ", " + statementType + ", " + scrollType + ") -- current cache size is " + this.numElements + "/" + this.cacheSize, this);
            OracleLog.recursiveTrace = false;
        }
        if (!this.implicitCacheEnabled) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "searchImplicitCache: implicit cache not enabled, returning null", this);
                OracleLog.recursiveTrace = false;
            }
            return null;
        }
        OracleStatementCacheEntry entry = null;
        entry = this.implicitCacheStart;
        while (!(entry == null || entry.statementType == statementType && entry.scrollType == scrollType && entry.sql.equals(sql))) {
            entry = entry.implicitNext;
        }
        if (entry != null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "searchImplicitCache: Found statement with key " + sql + "$$" + statementType + "$$" + scrollType, this);
                OracleLog.recursiveTrace = false;
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            if (entry.implicitPrev != null) {
                entry.implicitPrev.implicitNext = entry.implicitNext;
            }
            if (entry.implicitNext != null) {
                entry.implicitNext.implicitPrev = entry.implicitPrev;
            }
            if (this.implicitCacheStart == entry) {
                this.implicitCacheStart = entry.implicitNext;
            }
            --this.numElements;
            entry.statement.exitImplicitCacheToActive();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINE, "searchImplicitCache - return statement from cache", this);
                OracleLog.recursiveTrace = false;
            }
            return entry.statement;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "searchImplicitCache - return null", this);
            OracleLog.recursiveTrace = false;
        }
        return null;
    }

    protected OracleStatement searchExplicitCache(String key) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "searchExplicitCache(" + key + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (!this.explicitCacheEnabled) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "searchExplicitCache: explicit cache not enabled, returning null", this);
                OracleLog.recursiveTrace = false;
            }
            return null;
        }
        OracleStatementCacheEntry entry = null;
        entry = this.explicitCacheStart;
        while (entry != null && !entry.sql.equals(key)) {
            entry = entry.explicitNext;
        }
        if (entry != null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINER, "searchExplicitCache: Found statement with key " + entry.sql, this);
                OracleLog.recursiveTrace = false;
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            if (entry.explicitPrev != null) {
                entry.explicitPrev.explicitNext = entry.explicitNext;
            }
            if (entry.explicitNext != null) {
                entry.explicitNext.explicitPrev = entry.explicitPrev;
            }
            if (this.explicitCacheStart == entry) {
                this.explicitCacheStart = entry.explicitNext;
            }
            --this.numElements;
            entry.statement.exitExplicitCacheToActive();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINE, "searchExplicitCache - return statement from cache", this);
                OracleLog.recursiveTrace = false;
            }
            return entry.statement;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "searchExplicitCache - return null", this);
            OracleLog.recursiveTrace = false;
        }
        return null;
    }

    protected void purgeImplicitCache() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "purgeImplicitCache() entry", this);
            OracleLog.recursiveTrace = false;
        }
        OracleStatementCacheEntry entry = this.implicitCacheStart;
        while (entry != null) {
            this.purgeCacheEntry(entry);
            entry = entry.implicitNext;
        }
        this.implicitCacheStart = null;
    }

    protected void purgeExplicitCache() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "purgeExplicitCache() entry", this);
            OracleLog.recursiveTrace = false;
        }
        OracleStatementCacheEntry entry = this.explicitCacheStart;
        while (entry != null) {
            this.purgeCacheEntry(entry);
            entry = entry.explicitNext;
        }
        this.explicitCacheStart = null;
    }

    private void purgeCacheEntry(OracleStatementCacheEntry entry) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "purgeCacheEntry()", this);
            OracleLog.recursiveTrace = false;
        }
        if (entry.applicationNext != null) {
            entry.applicationNext.applicationPrev = entry.applicationPrev;
        }
        if (entry.applicationPrev != null) {
            entry.applicationPrev.applicationNext = entry.applicationNext;
        }
        if (this.applicationCacheStart == entry) {
            this.applicationCacheStart = entry.applicationNext;
        }
        if (this.applicationCacheEnd == entry) {
            this.applicationCacheEnd = entry.applicationPrev;
        }
        if (entry.onImplicit) {
            if (entry.implicitNext != null) {
                entry.implicitNext.implicitPrev = entry.implicitPrev;
            }
            if (entry.implicitPrev != null) {
                entry.implicitPrev.implicitNext = entry.implicitNext;
            }
            if (this.implicitCacheStart == entry) {
                this.implicitCacheStart = entry.implicitNext;
            }
        } else {
            if (entry.explicitNext != null) {
                entry.explicitNext.explicitPrev = entry.explicitPrev;
            }
            if (entry.explicitPrev != null) {
                entry.explicitPrev.explicitNext = entry.explicitNext;
            }
            if (this.explicitCacheStart == entry) {
                this.explicitCacheStart = entry.explicitNext;
            }
        }
        --this.numElements;
        if (entry.onImplicit) {
            entry.statement.exitImplicitCacheToClose();
        } else {
            entry.statement.exitExplicitCacheToClose();
        }
    }

    public int getCacheSize() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "getCacheSize(), returning " + this.cacheSize, this);
            OracleLog.recursiveTrace = false;
        }
        return this.cacheSize;
    }

    public void printCache(String msg) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + msg + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
        System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
        OracleStatementCacheEntry e = this.applicationCacheStart;
        while (e != null) {
            e.print();
            e = e.applicationNext;
        }
        System.out.println("implicitStart: " + this.implicitCacheStart);
        e = this.implicitCacheStart;
        while (e != null) {
            e.print();
            e = e.implicitNext;
        }
        System.out.println("explicitStart: " + this.explicitCacheStart);
        e = this.explicitCacheStart;
        while (e != null) {
            e.print();
            e = e.explicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + msg + ") ***");
    }

    public void close() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "LRUStatementCache.close()", this);
            OracleLog.recursiveTrace = false;
        }
        OracleStatementCacheEntry entry = this.applicationCacheStart;
        while (entry != null) {
            if (entry.onImplicit) {
                entry.statement.exitImplicitCacheToClose();
            } else {
                entry.statement.exitExplicitCacheToClose();
            }
            entry = entry.applicationNext;
        }
        this.applicationCacheStart = null;
        this.applicationCacheEnd = null;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.numElements = 0;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.LRUStatementCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

