/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean atLeastOneOrdinalParameter = false;
    boolean atLeastOneNamedParameter = false;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:05_PST_2008";

    OracleCallableStatement(PhysicalConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.OracleCallableStatement(conn, sql,batchValue, rowPrefetchValue)", this);
            OracleLog.recursiveTrace = false;
        }
    }

    OracleCallableStatement(PhysicalConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sql, 1, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.OracleCallableStatement(conn, sql, batchValue, rowPrefetchValue, UserResultSetType=" + UserResultSetType + ", UserResultSetConcur)", this);
            OracleLog.recursiveTrace = false;
        }
        this.statementType = 2;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.OracleCallableStatement:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void registerOutParameterInternal(int paramIndex, int external_type, int scale, int maxLength, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (external_type == 0) {
            DatabaseError.throwSqlException(4);
        }
        int internal_type = this.getInternalType(external_type);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (external_type) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: {
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        this.currentRowBindAccessors[index] = this.allocateAccessor(internal_type, external_type, index + 1, maxLength, this.currentRowFormOfUse[index], sqlName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameter(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", sqlName=" + sqlName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (sqlName == null || sqlName.length() == 0) {
            DatabaseError.throwSqlException(60, "empty Object name");
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.registerOutParameterInternal(paramIndex, sqlType, 0, 0, sqlName);
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameter(paramIndex, sqlType, sqlName):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void registerOutParameterBytes(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.registerOutParameterBytes(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameterBytes(paramIndex, sqlType, scale, maxLength):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void registerOutParameterChars(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.registerOutParameterChars(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameterChars(paramIndex, sqlType, scale, maxLength):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.registerOutParameter(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameter(paramIndex, sqlType, scale, maxLength):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale, int maxLength) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.registerOutParameter(parameterName=" + parameterName + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")", this);
            OracleLog.recursiveTrace = false;
        }
        int index = this.addNamedPara(parameterName);
        this.registerOutParameter(index, sqlType, scale, maxLength);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerOutParameter(parameterName, sqlType, scale, maxLength):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    void resetBatch() {
        this.batch = 1;
    }

    public synchronized void setExecuteBatch(int nrows) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.setExecuteBatch(nrows=" + nrows + ")", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized int sendBatch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.sendBatch()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.validRows;
    }

    public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, 0, -1);
    }

    public void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, scale, -1);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    public String getString(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getString(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getString(this.currentRank);
    }

    public Datum getOracleObject(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getOracleObject(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getOracleObject(this.currentRank);
    }

    public ROWID getROWID(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getROWID(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getROWID(this.currentRank);
    }

    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getNUMBER(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getNUMBER(this.currentRank);
    }

    public DATE getDATE(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getDATE(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDATE(this.currentRank);
    }

    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getINTERVALYM(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getINTERVALYM(this.currentRank);
    }

    public INTERVALDS getINTERVALDS(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getINTERVALDS(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getINTERVALDS(this.currentRank);
    }

    public TIMESTAMP getTIMESTAMP(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTIMESTAMP(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTIMESTAMP(this.currentRank);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTIMESTAMPTZ(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTIMESTAMPTZ(this.currentRank);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTIMESTAMPTLTZ(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTIMESTAMPLTZ(this.currentRank);
    }

    public REF getREF(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getREF(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getREF(this.currentRank);
    }

    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getARRAY(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getSTRUCT(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getSTRUCT(this.currentRank);
    }

    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getOPAQUE(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getOPAQUE(this.currentRank);
    }

    public CHAR getCHAR(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getCHAR(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCHAR(this.currentRank);
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getCharacterStream(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCharacterStream(this.currentRank);
    }

    public RAW getRAW(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getRAW(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getRAW(this.currentRank);
    }

    public BLOB getBLOB(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBLOB(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public CLOB getCLOB(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getCLOB(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public BFILE getBFILE(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBFILE(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBFILE(this.currentRank);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBoolean(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBoolean(this.currentRank);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getByte(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getByte(this.currentRank);
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getShort(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getShort(this.currentRank);
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getInt(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getInt(this.currentRank);
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getLong(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getLong(this.currentRank);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getFloat(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getFloat(this.currentRank);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getDouble(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDouble(this.currentRank);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBigDecimal(" + parameterIndex + ", " + scale + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBytes(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBytes(this.currentRank);
    }

    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBytes(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.privateGetBytes(this.currentRank);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getDate(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDate(this.currentRank);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTime(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTime(this.currentRank);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTimestamp(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getAsciiStream(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getAsciiStream(this.currentRank);
    }

    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getUnicodeStream(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getUnicodeStream(this.currentRank);
    }

    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBinaryStream(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBinaryStream(this.currentRank);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getObject(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getObject(this.currentRank);
    }

    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getAnyDataEmbeddedObject(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getAnyDataEmbeddedObject(this.currentRank);
    }

    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getCustomDatum(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCustomDatum(this.currentRank, factory);
    }

    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getORAData(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getORAData(this.currentRank, factory);
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getCursor(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCursor(this.currentRank);
    }

    public synchronized void clearParameters() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.clearParameters()", this);
            OracleLog.recursiveTrace = false;
        }
        super.clearParameters();
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getObject(" + parameterIndex + ", " + map + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getObject(this.currentRank, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getRef(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getREF(this.currentRank);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBlob(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getClob(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public Array getArray(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getArray(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getBigDecimal(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getDate(" + parameterIndex + ", " + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDate(this.currentRank, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTime(" + parameterIndex + ", " + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTime(this.currentRank, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getTimestamp(" + parameterIndex + ", " + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTimestamp(this.currentRank, cal);
    }

    public void addBatch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.addBatch()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.currentRowBindAccessors != null) {
            DatabaseError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    protected void alwaysOnClose() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.alwaysOnClose()", this);
            OracleLog.recursiveTrace = false;
        }
        this.sqlObject.resetNamedParameters();
        this.parameterCount = 0;
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        super.alwaysOnClose();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.alwaysOnClose : return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, 0, -1);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, scale, -1);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.registerOutParameter(index, sqlType, typeName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getURL(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getURL(this.currentRank);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setURLInternal(index, val);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setNullInternal(index, sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBooleanInternal(index, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setByteInternal(index, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setShortInternal(index, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setIntInternal(index, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setLongInternal(index, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setFloatInternal(index, x);
    }

    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBinaryFloatInternal(index, x);
    }

    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBinaryFloatInternal(index, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setDoubleInternal(index, x);
    }

    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBinaryDoubleInternal(index, x);
    }

    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBinaryDoubleInternal(index, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBigDecimalInternal(index, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setStringInternal(index, x);
    }

    public void setStringForClob(String parameterName, String x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        if (x == null || x.length() == 0) {
            this.setNull(index, 2005);
            return;
        }
        this.setStringForClob(index, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringForClob(int paramIndex, String x) throws SQLException {
        if (x == null || x.length() == 0) {
            this.setNull(paramIndex, 2005);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            PhysicalConnection physicalConnection2 = this.connection;
            synchronized (physicalConnection2) {
                this.setStringForClobCritical(paramIndex, x);
            }
        }
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBytesInternal(index, x);
    }

    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBytesForBlob(index, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        if (x == null || x.length == 0) {
            this.setNull(paramIndex, 2004);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            PhysicalConnection physicalConnection2 = this.connection;
            synchronized (physicalConnection2) {
                this.setBytesForBlobCritical(paramIndex, x);
            }
        }
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setDateInternal(index, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setTimeInternal(index, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setTimestampInternal(index, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setAsciiStreamInternal(index, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBinaryStreamInternal(index, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setObjectInternal(index, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterName, x, targetSqlType, 0);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setObjectInternal(index, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setCharacterStreamInternal(index, reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setDateInternal(index, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setTimeInternal(index, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setTimestampInternal(index, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setNullInternal(index, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getString(this.currentRank);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBoolean(this.currentRank);
    }

    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getByte(this.currentRank);
    }

    public short getShort(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getShort(this.currentRank);
    }

    public int getInt(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getInt(this.currentRank);
    }

    public long getLong(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getLong(this.currentRank);
    }

    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getFloat(this.currentRank);
    }

    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDouble(this.currentRank);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBytes(this.currentRank);
    }

    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDate(this.currentRank);
    }

    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTime(this.currentRank);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getObject(this.currentRank);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getObject(this.currentRank, map);
    }

    public Ref getRef(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getREF(this.currentRank);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public Clob getClob(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public Array getArray(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getDate(this.currentRank, cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTime(this.currentRank, cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getTimestamp(this.currentRank, cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        int parameterIndex;
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String iName = parameterName.toUpperCase().intern();
        for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
        }
        Accessor accessor = null;
        if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getURL(this.currentRank);
    }

    public synchronized void registerIndexTableOutParameter(int paramIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        int index;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerIndexTableOutParameter(paramIndex=" + paramIndex + ", maxLen=" + maxLen + ", elemSqlType=" + elemSqlType + ", elemMaxlen=" + elemMaxLen + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int internal_type = this.getInternalType(elemSqlType);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        this.currentRowBindAccessors[index] = this.allocateIndexTableAccessor(elemSqlType, internal_type, elemMaxLen, maxLen, this.currentRowFormOfUse[index], true);
        this.hasIbtBind = true;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.registerIndexTableOutParameter(paramIndex, maxLen, elemSqlType, elemMaxLen):return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int elemSqlType, int elemInternalType, int elemMaxLen, int maxNumOfElements, short form, boolean forBind) throws SQLException {
        return new PlsqlIndexTableAccessor(this, elemSqlType, elemInternalType, elemMaxLen, maxNumOfElements, form, forBind);
    }

    public synchronized Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.getPlsqlIndexTable(paramIndex=" + paramIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
        PlsqlIndexTableAccessor accessor = (PlsqlIndexTableAccessor)this.outBindAccessors[paramIndex - 1];
        int type = accessor.elementInternalType;
        Object[] jarray = null;
        switch (type) {
            case 9: {
                jarray = new String[darray.length];
                break;
            }
            case 6: {
                jarray = new BigDecimal[darray.length];
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "Invalid column type");
            }
        }
        for (int i = 0; i < jarray.length; ++i) {
            jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].toJdbc() : null;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleCallableStatement.getPlsqlIndexTable(paramIndex):return()", this);
            OracleLog.recursiveTrace = false;
        }
        return jarray;
    }

    public synchronized Object getPlsqlIndexTable(int paramIndex, Class primitiveType) throws SQLException {
        String type;
        Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
        if (primitiveType == null || !primitiveType.isPrimitive()) {
            DatabaseError.throwSqlException(68);
        }
        if ((type = primitiveType.getName()).equals("byte")) {
            byte[] jarray = new byte[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null ? darray[i].byteValue() : (byte)0;
            }
            return jarray;
        }
        if (type.equals("char")) {
            char[] jarray = new char[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? (char)darray[i].intValue() : (char)'\u0000';
            }
            return jarray;
        }
        if (type.equals("double")) {
            double[] jarray = new double[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].doubleValue() : 0.0;
            }
            return jarray;
        }
        if (type.equals("float")) {
            float[] jarray = new float[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].floatValue() : 0.0f;
            }
            return jarray;
        }
        if (type.equals("int")) {
            int[] jarray = new int[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].intValue() : 0;
            }
            return jarray;
        }
        if (type.equals("long")) {
            long[] jarray = new long[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].longValue() : 0L;
            }
            return jarray;
        }
        if (type.equals("short")) {
            short[] jarray = new short[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? (short)darray[i].intValue() : (short)0;
            }
            return jarray;
        }
        if (type.equals("boolean")) {
            boolean[] jarray = new boolean[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].booleanValue() : false;
            }
            return jarray;
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int parameterIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleCallableStatement.getOraclePlsqlIndexTable(" + parameterIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getOraclePlsqlIndexTable(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                return super.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                return super.executeUpdate();
            }
        }
    }

    void releaseBuffers() {
        if (this.outBindAccessors != null) {
            int len = this.outBindAccessors.length;
            for (int i = 0; i < len; ++i) {
                if (this.outBindAccessors[i] == null) continue;
                this.outBindAccessors[i].rowSpaceByte = null;
                this.outBindAccessors[i].rowSpaceChar = null;
            }
        }
        super.releaseBuffers();
    }

    void doLocalInitialization() {
        if (this.outBindAccessors != null) {
            int len = this.outBindAccessors.length;
            for (int i = 0; i < len; ++i) {
                if (this.outBindAccessors[i] == null) continue;
                this.outBindAccessors[i].rowSpaceByte = this.bindBytes;
                this.outBindAccessors[i].rowSpaceChar = this.bindChars;
            }
        }
    }

    public synchronized void setNull(int paramIndex, int x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNullInternal(paramIndex, x);
    }

    public synchronized void setBoolean(int paramIndex, boolean x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBooleanInternal(paramIndex, x);
    }

    public synchronized void setByte(int paramIndex, byte x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setByteInternal(paramIndex, x);
    }

    public synchronized void setShort(int paramIndex, short x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setShortInternal(paramIndex, x);
    }

    public synchronized void setInt(int paramIndex, int x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setIntInternal(paramIndex, x);
    }

    public synchronized void setLong(int paramIndex, long x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setLongInternal(paramIndex, x);
    }

    public synchronized void setFloat(int paramIndex, float x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setFloatInternal(paramIndex, x);
    }

    public synchronized void setBinaryFloat(int paramIndex, float x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(paramIndex, x);
    }

    public synchronized void setBinaryFloat(int paramIndex, BINARY_FLOAT x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(paramIndex, x);
    }

    public synchronized void setBinaryDouble(int paramIndex, double x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(paramIndex, x);
    }

    public synchronized void setBinaryDouble(int paramIndex, BINARY_DOUBLE x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(paramIndex, x);
    }

    public synchronized void setDouble(int paramIndex, double x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDoubleInternal(paramIndex, x);
    }

    public synchronized void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBigDecimalInternal(paramIndex, x);
    }

    public synchronized void setString(int paramIndex, String x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setStringInternal(paramIndex, x);
    }

    public synchronized void setFixedCHAR(int paramIndex, String x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setFixedCHARInternal(paramIndex, x);
    }

    public synchronized void setCursor(int paramIndex, ResultSet x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCursorInternal(paramIndex, x);
    }

    public synchronized void setROWID(int paramIndex, ROWID x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setROWIDInternal(paramIndex, x);
    }

    public synchronized void setRAW(int paramIndex, RAW x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRAWInternal(paramIndex, x);
    }

    public synchronized void setCHAR(int paramIndex, CHAR x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCHARInternal(paramIndex, x);
    }

    public synchronized void setDATE(int paramIndex, DATE x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDATEInternal(paramIndex, x);
    }

    public synchronized void setNUMBER(int paramIndex, NUMBER x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNUMBERInternal(paramIndex, x);
    }

    public synchronized void setBLOB(int paramIndex, BLOB x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBLOBInternal(paramIndex, x);
    }

    public synchronized void setBlob(int paramIndex, Blob x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBlobInternal(paramIndex, x);
    }

    public synchronized void setCLOB(int paramIndex, CLOB x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCLOBInternal(paramIndex, x);
    }

    public synchronized void setClob(int paramIndex, Clob x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setClobInternal(paramIndex, x);
    }

    public synchronized void setBFILE(int paramIndex, BFILE x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBFILEInternal(paramIndex, x);
    }

    public synchronized void setBfile(int paramIndex, BFILE x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBfileInternal(paramIndex, x);
    }

    public synchronized void setBytes(int paramIndex, byte[] x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBytesInternal(paramIndex, x);
    }

    public synchronized void setInternalBytes(int paramIndex, byte[] x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setInternalBytesInternal(paramIndex, x, y);
    }

    public synchronized void setDate(int paramIndex, Date x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDateInternal(paramIndex, x);
    }

    public synchronized void setTime(int paramIndex, Time x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimeInternal(paramIndex, x);
    }

    public synchronized void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(paramIndex, x);
    }

    public synchronized void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setINTERVALYMInternal(paramIndex, x);
    }

    public synchronized void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setINTERVALDSInternal(paramIndex, x);
    }

    public synchronized void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPInternal(paramIndex, x);
    }

    public synchronized void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPTZInternal(paramIndex, x);
    }

    public synchronized void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPLTZInternal(paramIndex, x);
    }

    public synchronized void setAsciiStream(int paramIndex, InputStream x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setAsciiStreamInternal(paramIndex, x, y);
    }

    public synchronized void setBinaryStream(int paramIndex, InputStream x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryStreamInternal(paramIndex, x, y);
    }

    public synchronized void setUnicodeStream(int paramIndex, InputStream x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setUnicodeStreamInternal(paramIndex, x, y);
    }

    public synchronized void setCharacterStream(int paramIndex, Reader x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCharacterStreamInternal(paramIndex, x, y);
    }

    public synchronized void setDate(int paramIndex, Date x, Calendar y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDateInternal(paramIndex, x, y);
    }

    public synchronized void setTime(int paramIndex, Time x, Calendar y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimeInternal(paramIndex, x, y);
    }

    public synchronized void setTimestamp(int paramIndex, Timestamp x, Calendar y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(paramIndex, x, y);
    }

    public synchronized void setURL(int paramIndex, URL x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setURLInternal(paramIndex, x);
    }

    public void setNull(int paramIndex, int x, String y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNullInternal(paramIndex, x, y);
    }

    public void setArray(int paramIndex, Array x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setArrayInternal(paramIndex, x);
    }

    public void setARRAY(int paramIndex, ARRAY x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setARRAYInternal(paramIndex, x);
    }

    public void setOPAQUE(int paramIndex, OPAQUE x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOPAQUEInternal(paramIndex, x);
    }

    public void setStructDescriptor(int paramIndex, StructDescriptor x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setStructDescriptorInternal(paramIndex, x);
    }

    public void setSTRUCT(int paramIndex, STRUCT x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setSTRUCTInternal(paramIndex, x);
    }

    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCustomDatumInternal(paramIndex, x);
    }

    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setORADataInternal(paramIndex, x);
    }

    public void setObject(int paramIndex, Object x, int y, int z) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(paramIndex, x, y, z);
    }

    public void setObject(int paramIndex, Object x, int y) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(paramIndex, x, y);
    }

    public void setRefType(int paramIndex, REF x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefTypeInternal(paramIndex, x);
    }

    public void setRef(int paramIndex, Ref x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefInternal(paramIndex, x);
    }

    public void setREF(int paramIndex, REF x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setREFInternal(paramIndex, x);
    }

    public void setObject(int paramIndex, Object x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(paramIndex, x);
    }

    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOracleObjectInternal(paramIndex, x);
    }

    public synchronized void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
    }

    int addNamedPara(String parameterName) throws SQLException {
        String iParameterName = parameterName.toUpperCase().intern();
        for (int i = 0; i < this.parameterCount; ++i) {
            if (iParameterName != this.namedParameters[i]) continue;
            return i + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] newList = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, newList, 0, this.namedParameters.length);
            this.namedParameters = newList;
        }
        this.namedParameters[this.parameterCount++] = iParameterName;
        this.atLeastOneNamedParameter = true;
        return this.parameterCount;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleCallableStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

