/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool = null;
    boolean isPool = false;
    boolean aliasing = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:05_PST_2008";

    public OracleOCIConnection(String ur, String us, String p, String db, Properties info, Object ext) throws SQLException {
        this(ur, us, p, db, info, (OracleDriverExtension)ext);
    }

    OracleOCIConnection(String ur, String us, String p, String db, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, us, p, db, info, ext);
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        byte[] connId = this.t2cGetConnectionId(this.m_nativeState);
        this.aliasing = true;
        return connId;
    }

    public synchronized void passwordChange(String user, String oldPassword, String newPassword) throws SQLException, IOException {
        this.ociPasswordChange(user, oldPassword, newPassword);
    }

    public synchronized void close() throws SQLException {
        if (this.lifecycle == 2 || this.lifecycle == 4 || this.aliasing) {
            return;
        }
        super.close();
        this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
    }

    public synchronized void setConnectionPool(OracleOCIConnectionPool cpool) {
        this.ociConnectionPool = cpool;
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        super.setStmtCacheSize(size, clearMetaData);
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleOCIConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

