/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    PhysicalConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:06_PST_2008";

    public OracleResultSetMetaData() {
    }

    public OracleResultSetMetaData(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData(conn, stmt)", this);
            OracleLog.recursiveTrace = false;
        }
        this.connection = conn;
        this.statement = stmt;
        stmt.describe();
        this.m_beginColumnIndex = 0;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    OracleResultSetMetaData(PhysicalConnection conn, OracleStatement stmt, int beginColumnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData(conn, stmt, ColIndex:" + beginColumnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.connection = conn;
        this.statement = stmt;
        stmt.describe();
        this.m_beginColumnIndex = beginColumnIndex;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public OracleResultSetMetaData(OracleResultSet rs) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData(rs)", this);
            OracleLog.recursiveTrace = false;
        }
        this.statement = (OracleStatement)rs.getStatement();
        this.connection = (PhysicalConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = rs.getFirstUserColumnIndex();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleResultSetMetaData.OracleResultSetMetaData:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public int getColumnCount() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "Rset Column count: " + (this.statement.getNumberOfColumns() - this.m_beginColumnIndex), this);
            OracleLog.recursiveTrace = false;
        }
        return this.statement.getNumberOfColumns() - this.m_beginColumnIndex;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    int getValidColumnIndex(int column) throws SQLException {
        int index = column + this.m_beginColumnIndex - 1;
        if (index < 0 || index >= this.statement.getNumberOfColumns()) {
            DatabaseError.throwSqlException(3, "getValidColumnIndex");
        }
        return index;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 1 || type == 12 || type == -1;
    }

    public boolean isSearchable(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type != -4 && type != -1 && type != 2004 && type != 2005 && type != -13 && type != 2002 && type != 2008 && type != 2007 && type != 2003 && type != 2006 && type != -10;
    }

    public boolean isCurrency(int column) throws SQLException {
        int l_type = this.getColumnType(column);
        return l_type == 2 || l_type == 6;
    }

    public int isNullable(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].nullable ? 1 : 0;
    }

    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].describeMaxLength;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.statement.getDescriptionWithNames()[index].columnName;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        switch (type) {
            case 112: 
            case 113: {
                return -1;
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.getDescription()[index].describeMaxLength;
            }
        }
        return this.getDescription()[index].precision;
    }

    public int getScale(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int _scale = this.getDescription()[index].scale;
        return _scale == -127 && this.statement.connection.j2ee13Compliant ? 0 : _scale;
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "Rset Column Type:<" + type + ">", this);
            OracleLog.recursiveTrace = false;
        }
        switch (type) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[index].precision != 0 && this.getDescription()[index].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return this.connection.v8Compatible ? 93 : 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType ntypeObj = (OracleNamedType)this.getDescription()[index].describeOtype;
                TypeDescriptor descriptor = TypeDescriptor.getTypeDescriptor(ntypeObj.getFullName(), this.connection);
                if (descriptor != null) {
                    return descriptor.getTypeCode();
                }
                DatabaseError.throwSqlException(60);
                return -1;
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR2";
            }
            case -1: {
                return "LONG";
            }
            case -3: {
                return "RAW";
            }
            case -4: {
                return "LONG RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 6: {
                return "FLOAT";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return this.connection.v8Compatible ? "DATE" : "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case -8: {
                return "ROWID";
            }
            case -10: {
                return "REFCURSOR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                int index = this.getValidColumnIndex(column);
                OracleTypeADT otype = (OracleTypeADT)this.getDescription()[index].describeOtype;
                return otype.getFullName();
            }
            case 2006: {
                int index = this.getValidColumnIndex(column);
                OracleTypeADT otype = (OracleTypeADT)this.getDescription()[index].describeOtype;
                return otype.getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        switch (type) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                if (this.getDescription()[index].precision != 0 && this.getDescription()[index].scale == -127) {
                    return "java.lang.Double";
                }
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 180: {
                return "oracle.sql.TIMESTAMP";
            }
            case 181: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case 231: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 182: {
                return "oracle.sql.INTERVALYM";
            }
            case 183: {
                return "oracle.sql.INTERVALDS";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "OracleResultSet";
            }
            case 109: {
                switch (this.getColumnType(column)) {
                    case 2003: {
                        return "oracle.sql.ARRAY";
                    }
                    case 2007: {
                        return "oracle.sql.OPAQUE";
                    }
                    case 2008: {
                        Class c;
                        OracleNamedType ntype = (OracleNamedType)this.getDescription()[index].describeOtype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (c = (Class)map.get(ntype.getFullName())) != null) {
                            return c.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, ntype.getSchemaName(), ntype.getSimpleName());
                    }
                    case 2002: {
                        Class c;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (c = (Class)map.get(((OracleNamedType)this.getDescription()[index].describeOtype).getFullName())) != null) {
                            return c.getName();
                        }
                        return "oracle.sql.STRUCT";
                    }
                }
                DatabaseError.throwSqlException(1);
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public boolean isNCHAR(int columnIndex) throws SQLException {
        int index = this.getValidColumnIndex(columnIndex);
        return this.getDescription()[index].formOfUse == 2;
    }

    Accessor[] getDescription() throws SQLException {
        return this.statement.getDescription();
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSetMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

