/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:07_PST_2008";

    SensitiveScrollableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        super(scrollStmt, rset, type, update);
        int valid_rows;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "SensitiveScrollableResultSet.SensitiveScrollableResultSet(scrollStmt, rset, type= " + type + " update=" + update + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if ((valid_rows = rset.getValidRows()) > 0) {
            this.beginLastFetchedIndex = 1;
            this.endLastFetchedIndex = valid_rows;
        } else {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = 0;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "SensitiveScrollableResultSet.SensitiveScrollableResultSet:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.next()) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.first()) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.last()) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.absolute(row)) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.relative(rows)) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (super.previous()) {
                    this.handle_refetch();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINE, "refreshRow()", this);
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isValidRow(this.currentRow)) {
                    DatabaseError.throwSqlException(11);
                }
                int direction = this.getFetchDirection();
                int realSz = 0;
                try {
                    realSz = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), direction);
                }
                catch (SQLException e) {
                    DatabaseError.throwSqlException(e, 90, "Unsupported syntax for refreshRow()");
                }
                if (realSz != 0) {
                    this.beginLastFetchedIndex = this.currentRow;
                    this.endLastFetchedIndex = this.currentRow + realSz - 1;
                }
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "refreshRow:return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    synchronized int removeRowInCache(int rowIdx) throws SQLException {
        int retval = super.removeRowInCache(rowIdx);
        if (retval != 0) {
            if (rowIdx >= this.beginLastFetchedIndex && rowIdx <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                --this.endLastFetchedIndex;
            } else {
                this.endLastFetchedIndex = 0;
                this.beginLastFetchedIndex = 0;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handle_refetch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SensitiveScrollableResultSet sensitiveScrollableResultSet = this;
            synchronized (sensitiveScrollableResultSet) {
                if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
                    return false;
                }
                this.refreshRow();
                return true;
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SensitiveScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

