/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class T2CInputStream
extends OracleInputStream {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:07_PST_2008";

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, byte[] var7, int var8, char[] var9, int var10, short[] var11, int var12);

    T2CInputStream(OracleStatement stmt, int index, Accessor a) {
        super(stmt, index, a);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "T2CInputStream.<init>(" + stmt + ", " + index + ", " + a + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "T2CInputStream.<init> returns " + this, this);
            OracleLog.recursiveTrace = false;
        }
    }

    T2CInputStream(int index) {
        super(null, index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            T2CInputStream t2CInputStream = this;
            synchronized (t2CInputStream) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINE, "T2CInputStream.getBytes(), statement" + this.statement + ", c_state" + this.statement.c_state, this);
                    OracleLog.recursiveTrace = false;
                }
                int dataSize = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.buf, this.chunkSize, this.statement.accessors, this.statement.defineBytes, this.statement.accessorByteOffset, this.statement.defineChars, this.statement.accessorCharOffset, this.statement.defineIndicators, this.statement.accessorShortOffset);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINE, "T2CInputStream.getBytes() returns dataSize = " + dataSize, this);
                    OracleLog.recursiveTrace = false;
                }
                if (dataSize == -2) {
                    try {
                        this.accessor.setNull(this.statement.currentRow);
                    }
                    catch (SQLException e) {
                        DatabaseError.SQLToIOException(e);
                    }
                    dataSize = 0;
                }
                if (dataSize <= 0) {
                    dataSize = -1;
                }
                return dataSize;
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

