/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;

class T4CDriverExtension
extends OracleDriverExtension {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:08_PST_2008";

    T4CDriverExtension() {
    }

    Connection getConnection(String url, String user, String password, String database, Properties info) throws SQLException {
        return new T4CConnection(url, user, password, database, info, this);
    }

    OracleStatement allocateStatement(PhysicalConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new T4CStatement(conn, resultSetType, resultSetConcurrency);
    }

    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new T4CPreparedStatement(conn, sql, resultSetType, resultSetConcurrency);
    }

    OracleCallableStatement allocateCallableStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new T4CCallableStatement(conn, sql, resultSetType, resultSetConcurrency);
    }

    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        return new T4CInputStream(stmt, index, accessor);
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

