/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIiov
extends T4CTTIMsg {
    T4C8TTIrxh rxh;
    T4CTTIrxd rxd;
    byte bindtype = 0;
    byte[] iovector;
    int bindcnt = 0;
    int inbinds = 0;
    int outbinds = 0;
    static final byte BV_IN_V = 32;
    static final byte BV_OUT_V = 16;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:08_PST_2008";

    T4CTTIiov(T4CMAREngine _mrengine, T4C8TTIrxh _rxh, T4CTTIrxd _rxd) throws SQLException, IOException {
        this.setMarshalingEngine(_mrengine);
        this.rxh = _rxh;
        this.rxd = _rxd;
    }

    void init() throws SQLException, IOException {
    }

    Accessor[] processRXD(Accessor[] outBindAccessors, int number_of_bind_positions, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, DBConversion conversion, byte[] tmpBindsByteArray, byte[] ioVector, InputStream[][] parameterStream, byte[][][] parameterDatum, OracleTypeADT[][] parameterOtype, OracleStatement oracleStatement, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators) throws SQLException, IOException {
        if (ioVector != null) {
            for (int i = 0; i < ioVector.length; ++i) {
                if ((ioVector[i] & 0x10) != 0 && (outBindAccessors == null || outBindAccessors.length <= i || outBindAccessors[i] == null)) {
                    int type;
                    int subRangeOffset = bindIndicatorSubRange + 5 + 10 * i;
                    int external_type = type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    if (type == 9) {
                        type = 1;
                    }
                    Accessor acc = oracleStatement.allocateAccessor(type, type, i, 0, (short)0, null, false);
                    acc.rowSpaceIndicator = null;
                    if (acc.defineType == 109 || acc.defineType == 111) {
                        acc.setOffsets(1);
                    }
                    if (outBindAccessors == null) {
                        outBindAccessors = new Accessor[i + 1];
                        outBindAccessors[i] = acc;
                        continue;
                    }
                    if (outBindAccessors.length <= i) {
                        Accessor[] outBindAccessorsNew = new Accessor[i + 1];
                        outBindAccessorsNew[i] = acc;
                        for (int ii = 0; ii < outBindAccessors.length; ++ii) {
                            if (outBindAccessors[ii] == null) continue;
                            outBindAccessorsNew[ii] = outBindAccessors[ii];
                        }
                        outBindAccessors = outBindAccessorsNew;
                        continue;
                    }
                    outBindAccessors[i] = acc;
                    continue;
                }
                if ((ioVector[i] & 0x10) != 0 || outBindAccessors == null || i >= outBindAccessors.length || outBindAccessors[i] == null) continue;
                outBindAccessors[i].isUseLess = true;
            }
        }
        return outBindAccessors;
    }

    void unmarshalV10() throws IOException, SQLException {
        this.rxh.unmarshalV10(this.rxd);
        this.bindcnt = this.rxh.numRqsts;
        this.iovector = new byte[this.bindcnt];
        for (int i = 0; i < this.bindcnt; ++i) {
            this.bindtype = this.meg.unmarshalSB1();
            if (this.bindtype == 0) {
                DatabaseError.throwSqlException(401);
            }
            if ((this.bindtype & 0x20) > 0) {
                int n = i;
                this.iovector[n] = (byte)(this.iovector[n] | 0x20);
                ++this.inbinds;
            }
            if ((this.bindtype & 0x10) <= 0) continue;
            int n = i;
            this.iovector[n] = (byte)(this.iovector[n] | 0x10);
            ++this.outbinds;
        }
    }

    byte[] getIOVector() {
        return this.iovector;
    }

    boolean isIOVectorEmpty() {
        return this.iovector.length == 0;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIiov"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

