/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.util.RepConversion;
import oracle.net.ns.BreakNetException;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.sql.converter.CharacterSetMetaData;

class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] user;
    String userStr;
    byte[] password;
    String passwordStr;
    byte[] terminal;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    long flag;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    String ressourceManagerId;
    T4CConnection conn;
    boolean isSessionTZ = true;
    Properties connectionValues = new Properties();
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:08_PST_2008";

    T4CTTIoauthenticate(T4CMAREngine _mrengine, String _user, String _password, Properties info, long _mode, String _ressourceManagerId, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)0);
        this.oer = _oer;
        this.setMarshalingEngine(_mrengine);
        this.user = _mrengine.conv.StringToCharBytes(_user);
        this.userStr = _user;
        this.passwordStr = _password;
        this.flag = _mode;
        this.ressourceManagerId = _ressourceManagerId;
        this.conn = _conn;
        this.setSessionFields(info);
        this.isSessionTZ = this.conn.ver.getVersionNumber() >= 8100;
    }

    void marshalOsesskey() throws IOException, SQLException {
        this.funCode = (short)118;
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSB4(this.user.length);
        this.meg.marshalUB4(this.flag | 1L);
        this.meg.marshalPTR();
        int nbPairs = 4;
        if (this.programName != null) {
            ++nbPairs;
        }
        this.meg.marshalUB4(nbPairs);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalCHR(this.user);
        byte[][] keys = new byte[nbPairs][];
        byte[][] values = new byte[nbPairs][];
        byte[] flags = new byte[nbPairs];
        int offset = 0;
        keys[offset] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        values[offset++] = this.terminal;
        if (this.programName != null) {
            keys[offset] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            values[offset++] = this.programName;
        }
        keys[offset] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        values[offset++] = this.machine;
        keys[offset] = this.meg.conv.StringToCharBytes(AUTH_PID);
        values[offset++] = this.processID;
        keys[offset] = this.meg.conv.StringToCharBytes(AUTH_SID);
        values[offset++] = this.sysUserName;
        this.meg.marshalKEYVAL(keys, values, flags, nbPairs);
    }

    void receiveOsesskey() throws IOException, SQLException {
        Object keys = null;
        Object values = null;
        block8: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            int nbPairs = this.meg.unmarshalUB2();
                            keys = new byte[nbPairs][];
                            values = new byte[nbPairs][];
                            this.meg.unmarshalKEYVAL((byte[][])keys, (byte[][])values, nbPairs);
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block8;
                        }
                        default: {
                            DatabaseError.throwSqlException(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        if (keys == null || ((byte[][])keys).length < 1) {
            DatabaseError.throwSqlException(438);
        }
        this.encryptedSK = values[0];
        if (this.encryptedSK == null || this.encryptedSK.length != 16) {
            DatabaseError.throwSqlException(438);
        }
    }

    void marshalOauth() throws IOException, SQLException {
        this.funCode = (short)115;
        if (this.encryptedSK.length > 16) {
            DatabaseError.throwSqlException(413);
        }
        String trimUser = this.userStr.trim();
        String trimPwd = this.passwordStr.trim();
        this.passwordStr = null;
        String noQuotesUser = trimUser;
        String noQuotesPwd = trimPwd;
        if (trimUser.startsWith("\"") || trimUser.endsWith("\"")) {
            noQuotesUser = this.removeQuotes(trimUser);
        }
        if (trimPwd.startsWith("\"") || trimPwd.endsWith("\"")) {
            noQuotesPwd = this.removeQuotes(trimPwd);
        }
        O3LoginClientHelper loginHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
        byte[] sessionKey = loginHelper.getSessionKey(noQuotesUser, noQuotesPwd, this.encryptedSK);
        byte[] passwordNet = this.meg.conv.StringToCharBytes(noQuotesPwd);
        byte pwdPadLen = passwordNet.length % 8 > 0 ? (byte)((byte)(8 - passwordNet.length % 8)) : (byte)0;
        byte[] paddedPwd = new byte[passwordNet.length + pwdPadLen];
        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
        byte[] ePwdOnSessKey = loginHelper.getEPasswd(sessionKey, paddedPwd);
        this.password = new byte[2 * paddedPwd.length + 1];
        if (this.password.length < 2 * ePwdOnSessKey.length) {
            DatabaseError.throwSqlException(413);
        }
        RepConversion.bArray2Nibbles(ePwdOnSessKey, this.password);
        this.password[this.password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSB4(this.user.length);
        this.meg.marshalUB4(this.flag | 1L | 0x100L);
        this.meg.marshalPTR();
        boolean xa_case = false;
        if (!this.ressourceManagerId.equals("0000")) {
            xa_case = true;
        }
        int nbPairs = 6;
        if (xa_case) {
            nbPairs += 2;
        }
        ++nbPairs;
        if (this.programName != null) {
            ++nbPairs;
        }
        if (this.clientname != null) {
            ++nbPairs;
        }
        this.meg.marshalUB4(nbPairs);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalCHR(this.user);
        byte[][] keys = new byte[nbPairs][];
        byte[][] values = new byte[nbPairs][];
        byte[] flags = new byte[nbPairs];
        int index = 0;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_PASSWORD);
        values[index++] = this.password;
        keys[index++] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        if (this.programName != null) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            values[index++] = this.programName;
        }
        if (this.clientname != null) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_PROXY_CLIENT_NAME);
            values[index++] = this.clientname;
        }
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        values[index++] = this.machine;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_PID);
        values[index++] = this.processID;
        if (xa_case) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            keys[index][keys[index].length - 1] = 0;
            values[index++] = this.internalName;
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            keys[index][keys[index].length - 1] = 0;
            values[index++] = this.externalName;
        }
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_ACL);
        values[index++] = this.aclValue;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_ALTER_SESSION);
        values[index] = this.alterSession;
        flags[index++] = 1;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_COPYRIGHT);
        values[index++] = this.meg.conv.StringToCharBytes(COPYRIGHT_STR);
        this.meg.marshalKEYVAL(keys, values, flags, nbPairs);
    }

    void marshalOauth(int type, Properties prop, int gl_session_id, int gl_serial_nb) throws IOException, SQLException {
        this.funCode = (short)115;
        boolean sendUser = false;
        boolean sendDN = false;
        boolean sendCertificate = false;
        boolean sendRoles = false;
        byte[] dn = null;
        byte[] certificate = null;
        Object roles = null;
        if (type == 1) {
            String _userStr = prop.getProperty("PROXY_USER_NAME");
            this.user = this.meg.conv.StringToCharBytes(_userStr);
            sendUser = true;
        } else if (type == 2) {
            String _dnStr = prop.getProperty("PROXY_DISTINGUISHED_NAME");
            dn = this.meg.conv.StringToCharBytes(_dnStr);
            sendDN = true;
        } else {
            try {
                certificate = (byte[])prop.get("PROXY_CERTIFICATE");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < certificate.length; ++i) {
                    String str = Integer.toHexString(0xFF & certificate[i]);
                    int length = str.length();
                    if (length == 0) {
                        sb.append("00");
                        continue;
                    }
                    if (length == 1) {
                        sb.append('0');
                        sb.append(str);
                        continue;
                    }
                    sb.append(str);
                }
                certificate = sb.toString().getBytes();
            }
            catch (Exception e) {
                // empty catch block
            }
            sendCertificate = true;
        }
        String[] strRoles = null;
        try {
            strRoles = (String[])prop.get("PROXY_ROLES");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (strRoles != null) {
            roles = new byte[strRoles.length][];
            for (int i = 0; i < strRoles.length; ++i) {
                roles[i] = this.meg.conv.StringToCharBytes(strRoles[i]);
            }
            sendRoles = true;
        }
        this.marshalFunHeader();
        if (sendUser) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(1025L);
        this.meg.marshalPTR();
        int nbPairs = 7;
        ++nbPairs;
        if (sendDN || sendCertificate) {
            ++nbPairs;
        }
        if (sendRoles) {
            nbPairs += ((byte[][])roles).length;
        }
        if (this.programName != null) {
            ++nbPairs;
        }
        this.meg.marshalUB4(nbPairs);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (sendUser) {
            this.meg.marshalCHR(this.user);
        }
        byte[][] keys = new byte[nbPairs][];
        byte[][] values = new byte[nbPairs][];
        byte[] flags = new byte[nbPairs];
        int index = 0;
        if (sendRoles) {
            for (int i = 0; i < ((byte[][])roles).length; ++i) {
                keys[index] = this.meg.conv.StringToCharBytes(AUTH_INITIAL_CLIENT_ROLE);
                values[index] = roles[i];
                ++index;
            }
        }
        if (sendDN) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_CLIENT_DN);
            values[index++] = dn;
        } else if (sendCertificate) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_CLIENT_CERTIFICATE);
            values[index++] = certificate;
        }
        keys[index++] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        if (this.programName != null) {
            keys[index] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            values[index++] = this.programName;
        }
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        values[index++] = this.machine;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_PID);
        values[index++] = this.processID;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_ACL);
        values[index++] = this.aclValue;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_ALTER_SESSION);
        values[index] = this.alterSession;
        flags[index++] = 1;
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_SESSION_ID);
        values[index++] = this.meg.conv.StringToCharBytes(Integer.toString(gl_session_id));
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_SERIAL_NUM);
        values[index++] = this.meg.conv.StringToCharBytes(Integer.toString(gl_serial_nb));
        keys[index] = this.meg.conv.StringToCharBytes(AUTH_COPYRIGHT);
        values[index++] = this.meg.conv.StringToCharBytes(COPYRIGHT_STR);
        this.meg.marshalKEYVAL(keys, values, flags, nbPairs);
    }

    void receiveOauth() throws IOException, SQLException {
        Object keys = null;
        Object values = null;
        int nbPairs = 0;
        block11: while (true) {
            try {
                block12: while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            nbPairs = this.meg.unmarshalUB2();
                            keys = new byte[nbPairs][];
                            values = new byte[nbPairs][];
                            this.meg.unmarshalKEYVAL((byte[][])keys, (byte[][])values, nbPairs);
                            break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning ea) {
                                this.conn.setWarnings(DatabaseError.addSqlWarning(this.conn.getWarnings(), ea));
                            }
                            continue block12;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block11;
                        }
                        default: {
                            DatabaseError.throwSqlException(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        for (int i = 0; i < nbPairs; ++i) {
            String keyStr = this.meg.conv.CharBytesToString(keys[i], keys[i].length);
            String valueStr = "";
            if (values[i] != null) {
                valueStr = this.meg.conv.CharBytesToString(values[i], values[i].length);
            }
            this.connectionValues.setProperty(keyStr, valueStr);
        }
    }

    int getSessionId() {
        int sessionId = -1;
        String valueStr = this.connectionValues.getProperty(AUTH_SESSION_ID);
        try {
            sessionId = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sessionId;
    }

    int getSerialNumber() {
        int serialNumber = -1;
        String valueStr = this.connectionValues.getProperty(AUTH_SERIAL_NUM);
        try {
            serialNumber = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return serialNumber;
    }

    void setSessionFields(Properties info) throws SQLException {
        String terminalStr = info.getProperty("v$session.terminal");
        String machineStr = info.getProperty("v$session.machine");
        String osuserStr = info.getProperty("v$session.osuser");
        String programStr = info.getProperty("v$session.program");
        String processStr = info.getProperty("v$session.process");
        String internalNameStr = info.getProperty("v$session.iname");
        String externalNameStr = info.getProperty("v$session.ename");
        String clientNameStr = info.getProperty(AUTH_PROXY_CLIENT_NAME);
        if (terminalStr == null) {
            terminalStr = "unknown";
        }
        if (machineStr == null) {
            try {
                machineStr = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                machineStr = "jdbcclient";
            }
        }
        if (osuserStr == null && (osuserStr = OracleDriver.getSystemPropertyUserName()) == null) {
            osuserStr = "jdbcuser";
        }
        if (processStr == null) {
            processStr = "1234";
        }
        if (internalNameStr == null) {
            internalNameStr = "jdbc_ttc_impl";
        }
        if (externalNameStr == null) {
            externalNameStr = "jdbc_" + this.ressourceManagerId;
        }
        this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
        this.machine = this.meg.conv.StringToCharBytes(machineStr);
        this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
        this.programName = this.meg.conv.StringToCharBytes(programStr == null ? "JDBC Thin Client" : programStr);
        this.processID = this.meg.conv.StringToCharBytes(processStr);
        this.internalName = this.meg.conv.StringToCharBytes(internalNameStr);
        this.externalName = this.meg.conv.StringToCharBytes(externalNameStr);
        if (clientNameStr != null) {
            this.clientname = this.meg.conv.StringToCharBytes(clientNameStr);
        }
        TimeZone tz = TimeZone.getDefault();
        int l_rawOffset = tz.getRawOffset();
        int hr = l_rawOffset / 3600000;
        int mi = l_rawOffset / 60000 % 60;
        if (tz.useDaylightTime() && tz.inDaylightTime(new Date())) {
            ++hr;
        }
        String TZ = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
        String nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault());
        String nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault());
        if (nlslanguage == null) {
            DatabaseError.throwSqlException(176);
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + TZ + "'" : "") + " NLS_LANGUAGE='" + nlslanguage + "' NLS_TERRITORY='" + nlsterritory + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }

    String removeQuotes(String str) {
        int i;
        int first = 0;
        int last = str.length() - 1;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\"') continue;
            first = i;
            break;
        }
        for (i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == '\"') continue;
            last = i;
            break;
        }
        String result = str.substring(first, last + 1);
        return result;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoauthenticate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

