/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int[] errorNumber;
    private String password;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:09_PST_2008";

    T4CXAResource(T4CConnection _physicalConn, OracleXAConnection xaconn, boolean _isTransLoose) throws XAException {
        super(_physicalConn, xaconn);
        this.physicalConn = _physicalConn;
        this.isTransLoose = _isTransLoose;
        this.errorNumber = new int[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int flag) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                block18: {
                    int swtch;
                    if (this.isTransLoose) {
                        flag |= 0x10000;
                    }
                    if ((swtch = flag & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                        return 0;
                    }
                    this.applicationValueArr[0] = 0;
                    try {
                        try {
                            T4CTTIOtxse otxse = this.physicalConn.otxse;
                            byte[] xidxid = null;
                            byte[] gtrid = xid.getGlobalTransactionId();
                            byte[] bqual = xid.getBranchQualifier();
                            int gtrid_l = 0;
                            int bqual_l = 0;
                            if (gtrid != null && bqual != null) {
                                gtrid_l = Math.min(gtrid.length, 64);
                                bqual_l = Math.min(bqual.length, 64);
                                xidxid = new byte[128];
                                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                            }
                            int t4cflag = 0;
                            t4cflag = (flag & 0x200000) != 0 || (flag & 0x8000000) != 0 ? (t4cflag |= 4) : (t4cflag |= 1);
                            if ((flag & 0x100) != 0) {
                                t4cflag |= 0x100;
                            }
                            if ((flag & 0x200) != 0) {
                                t4cflag |= 0x200;
                            }
                            if ((flag & 0x400) != 0) {
                                t4cflag |= 0x400;
                            }
                            if ((flag & 0x10000) != 0) {
                                t4cflag |= 0x10000;
                            }
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.marshal(1, null, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = 0;
                            byte[] ctx = otxse.receive(this.applicationValueArr);
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            DatabaseError.throwSqlException(ioe);
                        }
                    }
                    catch (SQLException s) {
                        returnVal = s.getErrorCode();
                        if (returnVal != 0) break block18;
                        throw new XAException(-6);
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                block17: {
                    try {
                        try {
                            T4CTTIOtxse otxse = this.physicalConn.otxse;
                            byte[] xidxid = null;
                            byte[] gtrid = xid.getGlobalTransactionId();
                            byte[] bqual = xid.getBranchQualifier();
                            int gtrid_l = 0;
                            int bqual_l = 0;
                            if (gtrid != null && bqual != null) {
                                gtrid_l = Math.min(gtrid.length, 64);
                                bqual_l = Math.min(bqual.length, 64);
                                xidxid = new byte[128];
                                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                            }
                            if (this.context == null && (returnVal = this.doStart(xid, 0x8000000)) != 0) {
                                return returnVal;
                            }
                            byte[] txctx = this.context;
                            int t4cflag = 0;
                            if ((flag & 2) == 2) {
                                t4cflag = 0x100000;
                            } else if ((flag & 0x2000000) == 0x2000000 && (flag & 0x100000) != 0x100000) {
                                t4cflag = 0x100000;
                                if (!isLocallySuspended) {
                                    this.applicationValueArr[0] = 65536;
                                }
                            }
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.marshal(2, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = 0;
                            byte[] ctx = otxse.receive(this.applicationValueArr);
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            DatabaseError.throwSqlException(ioe);
                        }
                    }
                    catch (SQLException s) {
                        returnVal = s.getErrorCode();
                        if (returnVal != 0) break block17;
                        throw new XAException(-6);
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doCommit(Xid xid, int cPhase) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                int command = cPhase == 1 ? 4 : 2;
                returnVal = this.doTransaction(xid, 1, command);
                if (cPhase == 1 && (returnVal == 2 || returnVal == 4)) {
                    returnVal = 0;
                } else if (cPhase != 1 && returnVal == 5) {
                    returnVal = 0;
                } else if (returnVal == 8) {
                    throw new XAException(106);
                }
                if (returnVal == 24756) {
                    return this.kputxrec(xid, 1, this.timeout + 120);
                }
                if (returnVal != 24780) return returnVal;
                OracleXADataSource oxds = null;
                PooledConnection pc = null;
                try {
                    try {
                        oxds = new OracleXADataSource();
                        oxds.setURL(this.physicalConn.url);
                        oxds.setUser(this.physicalConn.user);
                        this.physicalConn.getPasswordInternal(this);
                        oxds.setPassword(this.password);
                        pc = oxds.getXAConnection();
                        XAResource oxar = pc.getXAResource();
                        oxar.commit(xid, cPhase == 1);
                        returnVal = 0;
                    }
                    catch (SQLException e) {
                        throw new XAException(-6);
                    }
                    Object var11_11 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        if (pc != null) {
                            pc.close();
                        }
                        if (oxds == null) throw throwable;
                        oxds.close();
                        throw throwable;
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ee) {}
                if (pc != null) {
                    pc.close();
                }
                if (oxds == null) return returnVal;
                oxds.close();
                return returnVal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                returnVal = this.doTransaction(xid, 3, 0);
                if (returnVal == 8) {
                    throw new XAException(106);
                }
                if (returnVal == 4) {
                    returnVal = 24767;
                } else if (returnVal == 1) {
                    returnVal = 0;
                } else if (returnVal == 3) {
                    returnVal = 24761;
                } else {
                    switch (returnVal) {
                        case 2054: 
                        case 2056: 
                        case 2091: 
                        case 2092: 
                        case 24756: 
                        case 24761: 
                        case 24767: 
                        case 24775: {
                            break;
                        }
                        case 25351: {
                            returnVal = 17448;
                            break;
                        }
                        default: {
                            returnVal = 24768;
                        }
                    }
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doForget(Xid xid) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                if (OracleXid.isLocalTransaction(xid)) {
                    return 24771;
                }
                int resumeReturn = this.doStart(xid, 0x8000000);
                if (resumeReturn == 24756) return this.kputxrec(xid, 4, 1);
                if (resumeReturn == 0) {
                    try {
                        this.doEnd(xid, 0, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (resumeReturn == 0) return 24769;
                if (resumeReturn == 2079) return 24769;
                if (resumeReturn == 24754) return 24769;
                if (resumeReturn == 24761) return 24769;
                if (resumeReturn == 24774) return 24769;
                if (resumeReturn == 24776) return 24769;
                if (resumeReturn == 25351) {
                    return 24769;
                }
                if (resumeReturn != 24752) return resumeReturn;
                return 24771;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doRollback(Xid xid) throws XAException {
        int returnVal = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                returnVal = this.doTransaction(xid, 2, 3);
                if (returnVal == 8) {
                    throw new XAException(106);
                }
                if (returnVal == 3 || returnVal == 25402) {
                    returnVal = 0;
                }
                if (returnVal == 24756) {
                    return this.kputxrec(xid, 2, this.timeout + 120);
                }
                if (returnVal != 24780) return returnVal;
                OracleXADataSource oxds = null;
                PooledConnection pc = null;
                try {
                    try {
                        oxds = new OracleXADataSource();
                        oxds.setURL(this.physicalConn.url);
                        oxds.setUser(this.physicalConn.user);
                        this.physicalConn.getPasswordInternal(this);
                        oxds.setPassword(this.password);
                        pc = oxds.getXAConnection();
                        XAResource oxar = pc.getXAResource();
                        oxar.rollback(xid);
                        returnVal = 0;
                    }
                    catch (SQLException e) {
                        throw new XAException(-6);
                    }
                    Object var9_9 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        if (pc != null) {
                            pc.close();
                        }
                        if (oxds == null) throw throwable;
                        oxds.close();
                        throw throwable;
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ee) {}
                if (pc != null) {
                    pc.close();
                }
                if (oxds == null) return returnVal;
                oxds.close();
                return returnVal;
            }
        }
    }

    int doTransaction(Xid xid, int mode, int command) throws XAException {
        int returnVal = -1;
        try {
            try {
                T4CTTIOtxen otxen = this.physicalConn.otxen;
                byte[] xidxid = null;
                byte[] gtrid = xid.getGlobalTransactionId();
                byte[] bqual = xid.getBranchQualifier();
                int gtrid_l = 0;
                int bqual_l = 0;
                if (gtrid != null && bqual != null) {
                    gtrid_l = Math.min(gtrid.length, 64);
                    bqual_l = Math.min(bqual.length, 64);
                    xidxid = new byte[128];
                    System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                    System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                }
                byte[] txctx = this.context;
                this.physicalConn.needLine();
                this.physicalConn.sendPiggyBackedMessages();
                otxen.marshal(mode, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, command);
                returnVal = otxen.receive(this.errorNumber);
            }
            catch (IOException ioe) {
                DatabaseError.throwSqlException(ioe);
            }
        }
        catch (SQLException s) {
            this.errorNumber[0] = s.getErrorCode();
        }
        if (this.errorNumber[0] == 0) {
            throw new XAException(-6);
        }
        if (returnVal == -1) {
            returnVal = this.errorNumber[0];
        }
        return returnVal;
    }

    protected int kputxrec(Xid xid, int opcode, int tries) throws XAException {
        int incmd;
        int command;
        int rtnst = 0;
        switch (opcode) {
            case 1: {
                command = 3;
                break;
            }
            case 4: {
                command = 2;
                break;
            }
            default: {
                command = 0;
            }
        }
        int endstate = 0;
        while (tries-- > 0 && (endstate = this.doTransaction(xid, 5, command)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        if (endstate == 7) {
            return 24763;
        }
        if (endstate == 24756) {
            return 24756;
        }
        switch (endstate) {
            case 3: {
                if (opcode == 1) {
                    incmd = 7;
                    break;
                }
                incmd = 8;
                rtnst = -24762;
                break;
            }
            case 0: {
                if (opcode == 4) {
                    incmd = 8;
                    rtnst = 24762;
                    break;
                }
                incmd = 7;
                rtnst = opcode == 1 ? 24756 : 0;
                break;
            }
            case 2: {
                if (opcode == 4) {
                    incmd = 8;
                    rtnst = 24770;
                    break;
                }
            }
            default: {
                int[] heuristic = new int[1];
                rtnst = this.kpuho2oc(endstate, heuristic);
                if (opcode == 4 && heuristic[0] == 1) {
                    incmd = 7;
                    rtnst = 0;
                    break;
                }
                incmd = 8;
            }
        }
        T4CTTIk2rpc k2rpc = this.physicalConn.k2rpc;
        try {
            k2rpc.marshal(3, incmd);
            k2rpc.receive();
        }
        catch (IOException ioe) {
            throw new XAException(-7);
        }
        catch (SQLException s) {
            throw new XAException(-6);
        }
        return rtnst;
    }

    int kpuho2oc(int state, int[] heuristic) {
        int rtnst = 0;
        switch (state) {
            case 5: {
                heuristic[0] = 1;
                rtnst = 24764;
                break;
            }
            case 4: {
                heuristic[0] = 1;
                rtnst = 24765;
                break;
            }
            case 6: {
                heuristic[0] = 1;
                rtnst = 24766;
                break;
            }
            default: {
                rtnst = 24762;
            }
        }
        return rtnst;
    }

    final void setPasswordInternal(String p) {
        this.password = p;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

