/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;

    TimestamptzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        this.init(stmt, 181, 181, form, forBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    TimestamptzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, 181, 181, form, false);
        this.initForDescribe(181, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeMaxLength = 13;
        if (max_len > 0 && max_len < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = max_len;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int currentRow) throws SQLException {
        String regname;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
            return null;
        }
        int off = this.columnIndex + this.byteLength * currentRow;
        int regionID = 0;
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
            if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                TIMEZONETAB.updateTable(this.statement.connection, regionID);
            }
            regname = new String(ZONEIDMAP.getRegion(regionID));
        } else {
            int off_hour = this.oracleTZ1(off) - OFFSET_HOUR;
            int off_minute = this.oracleTZ2(off) - OFFSET_MINUTE;
            regname = new String(off_hour + ":" + off_minute);
        }
        TimeZone zone = TimeZone.getTimeZone(regname);
        Calendar cal = Calendar.getInstance(zone);
        int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
        cal.set(1, year);
        cal.set(2, this.oracleMonth(off));
        cal.set(5, this.oracleDay(off));
        cal.set(11, this.oracleHour(off));
        cal.set(12, this.oracleMin(off));
        cal.set(13, this.oracleSec(off));
        cal.set(14, 0);
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            int offset = TIMEZONETAB.getOffset(cal, regionID);
            boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
            boolean destinationTimeInDST = zone.inDaylightTime(new Date(cal.getTimeInMillis() + (long)offset));
            if (!sourceTimeInDST && destinationTimeInDST) {
                cal.add(14, -1 * zone.getDSTSavings());
            } else if (sourceTimeInDST && !destinationTimeInDST) {
                cal.add(14, zone.getDSTSavings());
            }
            cal.add(14, offset);
        } else {
            cal.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
            cal.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
        }
        year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int nanos = this.oracleNanos(off);
        return year + "-" + month + "-" + date + " " + hour + "." + min + "." + sec + "." + nanos + " " + regname;
    }

    java.sql.Date getDate(int currentRow) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
            return null;
        }
        int off = this.columnIndex + this.byteLength * currentRow;
        TimeZone zone = this.statement.getDefaultTimeZone();
        Calendar cal = Calendar.getInstance(zone);
        int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
        cal.set(1, year);
        cal.set(2, this.oracleMonth(off));
        cal.set(5, this.oracleDay(off));
        cal.set(11, this.oracleHour(off));
        cal.set(12, this.oracleMin(off));
        cal.set(13, this.oracleSec(off));
        cal.set(14, 0);
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            int regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
            if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                TIMEZONETAB.updateTable(this.statement.connection, regionID);
            }
            int offset = TIMEZONETAB.getOffset(cal, regionID);
            boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
            boolean destinationTimeInDST = zone.inDaylightTime(new Date(cal.getTimeInMillis() + (long)offset));
            if (!sourceTimeInDST && destinationTimeInDST) {
                cal.add(14, -1 * zone.getDSTSavings());
            } else if (sourceTimeInDST && !destinationTimeInDST) {
                cal.add(14, zone.getDSTSavings());
            }
            cal.add(10, offset / 3600000);
            cal.add(12, offset % 3600000 / 60000);
        } else {
            cal.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
            cal.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
        }
        long millis = cal.getTime().getTime();
        return new java.sql.Date(millis);
    }

    Time getTime(int currentRow) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
            return null;
        }
        int off = this.columnIndex + this.byteLength * currentRow;
        TimeZone zone = this.statement.getDefaultTimeZone();
        Calendar cal = Calendar.getInstance(zone);
        int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
        cal.set(1, year);
        cal.set(2, this.oracleMonth(off));
        cal.set(5, this.oracleDay(off));
        cal.set(11, this.oracleHour(off));
        cal.set(12, this.oracleMin(off));
        cal.set(13, this.oracleSec(off));
        cal.set(14, 0);
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            int regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
            if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                TIMEZONETAB.updateTable(this.statement.connection, regionID);
            }
            int offset = TIMEZONETAB.getOffset(cal, regionID);
            boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
            boolean destinationTimeInDST = zone.inDaylightTime(new Date(cal.getTimeInMillis() + (long)offset));
            if (!sourceTimeInDST && destinationTimeInDST) {
                cal.add(14, -1 * zone.getDSTSavings());
            } else if (sourceTimeInDST && !destinationTimeInDST) {
                cal.add(14, zone.getDSTSavings());
            }
            cal.add(10, offset / 3600000);
            cal.add(12, offset % 3600000 / 60000);
        } else {
            cal.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
            cal.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
        }
        long millis = cal.getTime().getTime();
        return new Time(millis);
    }

    Timestamp getTimestamp(int currentRow) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
            return null;
        }
        int off = this.columnIndex + this.byteLength * currentRow;
        TimeZone zone = this.statement.getDefaultTimeZone();
        Calendar cal = Calendar.getInstance(zone);
        int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
        cal.set(1, year);
        cal.set(2, this.oracleMonth(off));
        cal.set(5, this.oracleDay(off));
        cal.set(11, this.oracleHour(off));
        cal.set(12, this.oracleMin(off));
        cal.set(13, this.oracleSec(off));
        cal.set(14, 0);
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            int regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
            if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                TIMEZONETAB.updateTable(this.statement.connection, regionID);
            }
            int offset = TIMEZONETAB.getOffset(cal, regionID);
            boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
            boolean destinationTimeInDST = zone.inDaylightTime(new Date(cal.getTimeInMillis() + (long)offset));
            if (!sourceTimeInDST && destinationTimeInDST) {
                cal.add(14, -1 * zone.getDSTSavings());
            } else if (sourceTimeInDST && !destinationTimeInDST) {
                cal.add(14, zone.getDSTSavings());
            }
            cal.add(10, offset / 3600000);
            cal.add(12, offset % 3600000 / 60000);
        } else {
            cal.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
            cal.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
        }
        long millis = cal.getTime().getTime();
        Timestamp result = new Timestamp(millis);
        int nanos = this.oracleNanos(off);
        result.setNanos(nanos);
        return result;
    }

    Object getObject(int currentRow) throws SQLException {
        return this.getTIMESTAMPTZ(currentRow);
    }

    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getTIMESTAMPTZ(currentRow);
    }

    Object getObject(int currentRow, Map map) throws SQLException {
        return this.getTIMESTAMPTZ(currentRow);
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            int off = this.columnIndex + this.byteLength * currentRow;
            byte[] data = new byte[13];
            System.arraycopy(this.rowSpaceByte, off, data, 0, 13);
            result = new TIMESTAMPTZ(data);
        }
        return result;
    }

    static int setHighOrderbits(int ID) {
        return (ID & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int ID) {
        return (ID & 0x3F) << 2;
    }

    static int getHighOrderbits(int ID) {
        return (ID & 0x7F) << 6;
    }

    static int getLowOrderbits(int ID) {
        return (ID & 0xFC) >> 2;
    }
}

