/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:09_PST_2008";

    private OracleConnectionCacheManager() {
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        block3: {
            try {
                if (cacheManagerInstance == null) {
                    cacheManagerInstance = new OracleConnectionCacheManager();
                }
            }
            catch (RuntimeException re) {
                if (!TRACE || OracleLog.recursiveTrace) break block3;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheManager.getConnectionCacheManagerInstanceRuntimeException" + re);
                OracleLog.recursiveTrace = false;
            }
        }
        return cacheManagerInstance;
    }

    public String createCache(OracleDataSource ods, Properties cacheProperties) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.createCache(ods=" + ods + "cacheProperties=" + cacheProperties + ")", this);
            OracleLog.recursiveTrace = false;
        }
        String connectionCacheName = null;
        if (ods == null || !ods.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        connectionCacheName = ods.connCacheName != null ? ods.connCacheName : ods.dataSourceName + "#0x" + Integer.toHexString(this.m_connCache.size());
        this.createCache(connectionCacheName, ods, cacheProperties);
        return connectionCacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String cacheName, OracleDataSource ods, Properties cacheProperties) throws SQLException {
        boolean _odsIsFcfEnabled;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.createCache(cacheName=" + cacheName + "ods=" + ods + "cacheProperties=" + cacheProperties + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (ods == null || !ods.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        if (cacheName == null) {
            DatabaseError.throwSqlException(138);
        }
        if (this.m_connCache.containsKey(cacheName)) {
            DatabaseError.throwSqlException(140);
        }
        if ((_odsIsFcfEnabled = ods.getFastConnectionFailoverEnabled()) && this.failoverEventHandlerThread == null) {
            final String onsConfigStr = ods.getONSConfiguration();
            if (onsConfigStr != null && !onsConfigStr.equals("")) {
                OracleConnectionCacheManager oracleConnectionCacheManager = this;
                synchronized (oracleConnectionCacheManager) {
                    if (!isONSInitializedForRemoteSubscription) {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws ONSException {
                                    ONS ons = new ONS(onsConfigStr);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException onsexc) {
                            DatabaseError.throwSqlException(175, onsexc);
                        }
                        isONSInitializedForRemoteSubscription = true;
                    }
                }
            }
            this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
        }
        OracleImplicitConnectionCache icc = new OracleImplicitConnectionCache(ods, cacheProperties);
        icc.cacheName = cacheName;
        ods.odsCache = icc;
        this.m_connCache.put(cacheName, icc);
        if (_odsIsFcfEnabled) {
            this.checkAndStartThread(this.failoverEventHandlerThread);
        }
    }

    public void removeCache(String cacheName, long waitTimeout) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.removeCache(cacheName=" + cacheName + "waitTimeout=" + waitTimeout + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(cacheName) : null;
        if (oicc != null) {
            block7: {
                oicc.disableConnectionCache();
                if (waitTimeout > 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(waitTimeout * 1000L);
                    }
                    catch (InterruptedException ea) {
                        if (!TRACE || OracleLog.recursiveTrace) break block7;
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheManager.removeCacheGot an InterruptedException" + ea, this);
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
            if (oicc.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.cleanupFCFThreads(oicc);
            }
            oicc.closeConnectionCache(waitTimeout < 0L ? 32 : 1);
            oicc = null;
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void reinitializeCache(String cacheName, Properties cacheProperties) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.reinitializeCache(cacheName=" + cacheName + "cacheProperties=" + cacheProperties + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            this.disableCache(cacheName);
            oicc.reinitializeCacheConnections(cacheProperties);
            this.enableCache(cacheName);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public boolean existsCache(String cacheName) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.existsCache(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return this.m_connCache.containsKey(cacheName);
    }

    public void enableCache(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.enabledCache(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            oicc.enableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void disableCache(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.disableCache(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            oicc.disableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void refreshCache(String cacheName, int mode) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.refreshCache(cacheName=" + cacheName + "mode=" + mode + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            switch (mode) {
                case 4096: 
                case 8192: {
                    oicc.refreshCacheConnections(mode);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(68);
                    break;
                }
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void purgeCache(String cacheName, boolean cleanupCheckedOutConnections) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.purgeCache(cacheName=" + cacheName + "cleanupCheckedOutConnections=" + cleanupCheckedOutConnections + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            oicc.purgeCacheConnections(cleanupCheckedOutConnections, 1);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public Properties getCacheProperties(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.getCacheProperties(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.getConnectionCacheProperties();
        }
        DatabaseError.throwSqlException(141);
        return null;
    }

    public String[] getCacheNameList() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.getCacheNameList()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
    }

    public int getNumberOfAvailableConnections(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.getNumberOfAvailableConnections(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.cacheSize;
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public int getNumberOfActiveConnections(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.getNumberOfActiveConnections(cacheName=" + cacheName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.getNumberOfCheckedOutConnections();
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public synchronized void setConnectionPoolDataSource(String cacheName, ConnectionPoolDataSource ds) throws SQLException {
        OracleImplicitConnectionCache oicc;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.setConnectionPoolDataSource(cacheName=" + cacheName + ", DataSource=" + ds + ")", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            if (oicc.cacheSize > 0) {
                DatabaseError.throwSqlException(78);
            } else {
                ((OracleConnectionPoolDataSource)ds).makeURL();
                ((OracleConnectionPoolDataSource)ds).setURL(((OracleConnectionPoolDataSource)ds).url);
                oicc.connectionPoolDS = (OracleConnectionPoolDataSource)ds;
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    protected void verifyAndHandleEvent(int eventType, byte[] eventBody) throws SQLException {
        StringTokenizer strTokens;
        int cardinality;
        String status;
        String hostNameKey;
        String dbUniqNameKey;
        String instNameKey;
        String svcName;
        block14: {
            svcName = null;
            instNameKey = null;
            dbUniqNameKey = null;
            hostNameKey = null;
            status = null;
            cardinality = 0;
            strTokens = null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "eventType=" + eventType + "eventBody=<" + new String(eventBody) + ">", this);
                OracleLog.recursiveTrace = false;
            }
            try {
                strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
            }
            catch (UnsupportedEncodingException e) {
                if (!TRACE || OracleLog.recursiveTrace) break block14;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "UTF-8 Encoding Exception " + e, this);
                OracleLog.recursiveTrace = false;
            }
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                DatabaseError.throwSqlException(146);
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                svcName = val;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                instNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                dbUniqNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                hostNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                status = val;
            }
            if (!key.equalsIgnoreCase("card") || val == null) continue;
            try {
                cardinality = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                if (!TRACE || OracleLog.recursiveTrace) continue;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "Cardinality value= " + val + nfe, this);
                OracleLog.recursiveTrace = false;
            }
        }
        this.invokeFailoverProcessingThreads(eventType, svcName, instNameKey, dbUniqNameKey, hostNameKey, status, cardinality);
        strTokens = null;
    }

    private void invokeFailoverProcessingThreads(int eventType, String svcName, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        OracleImplicitConnectionCache oicc = null;
        boolean serviceEvent = false;
        boolean hostEvent = false;
        if (eventType == 256) {
            serviceEvent = true;
        }
        if (eventType == 512) {
            hostEvent = true;
        }
        Iterator itr = this.m_connCache.values().iterator();
        while (itr.hasNext()) {
            oicc = (OracleImplicitConnectionCache)itr.next();
            if ((!serviceEvent || !svcName.equalsIgnoreCase(oicc.dataSourceServiceName)) && !hostEvent) continue;
            OracleFailoverWorkerThread workerTh = new OracleFailoverWorkerThread(oicc, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
            this.checkAndStartThread(workerTh);
            oicc.failoverWorkerThread = workerTh;
        }
    }

    protected void checkAndStartThread(Thread thr) throws SQLException {
        block3: {
            try {
                if (!thr.isAlive()) {
                    thr.setDaemon(true);
                    thr.start();
                }
            }
            catch (IllegalThreadStateException ie) {
                if (!TRACE || OracleLog.recursiveTrace) break block3;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheManager.checkAndStartThread()" + ie, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    protected boolean failoverEnabledCacheExists() {
        return this.failoverEnabledCacheCount > 0;
    }

    protected void parseRuntimeLoadBalancingEvent(String service, byte[] eventBody) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINER, "(RLB) eventBody=<" + eventBody == null ? null : new String(eventBody) + ">", this);
            OracleLog.recursiveTrace = false;
        }
        OracleImplicitConnectionCache icc = null;
        Enumeration iccSet = this.m_connCache.elements();
        while (iccSet.hasMoreElements()) {
            try {
                icc = (OracleImplicitConnectionCache)iccSet.nextElement();
                if (!service.equalsIgnoreCase(icc.dataSourceServiceName)) continue;
                if (eventBody == null) {
                    icc.zapRLBInfo();
                    continue;
                }
                this.retrieveServiceMetrics(icc, eventBody);
            }
            catch (Exception e) {
                if (!TRACE || OracleLog.recursiveTrace) continue;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "(RLB)OracleConnectionCacheManager.parseRuntimeLoadBalancingEvent()" + e, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private void retrieveServiceMetrics(OracleImplicitConnectionCache icc, byte[] eventBody) throws SQLException {
        boolean updateNecessary;
        int flag;
        int percent;
        String dbUniqNameKey;
        String instNameKey;
        StringTokenizer strTokens;
        block17: {
            strTokens = null;
            instNameKey = null;
            dbUniqNameKey = null;
            percent = 0;
            flag = 0;
            updateNecessary = false;
            try {
                strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
            }
            catch (UnsupportedEncodingException e) {
                if (!TRACE || OracleLog.recursiveTrace) break block17;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "(RLB)UTF-8 Encoding Exception " + e, this);
                OracleLog.recursiveTrace = false;
            }
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            block18: {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    if (st.equals("}")) {
                        if (!updateNecessary) continue;
                        icc.updateDatabaseInstance(dbUniqNameKey, instNameKey, percent, flag);
                        updateNecessary = false;
                        continue;
                    }
                    if (st.equals("{") || st.equals(" ")) continue;
                    key = st;
                    updateNecessary = true;
                }
                if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                    DatabaseError.throwSqlException(146);
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("instance") && val != null) {
                    instNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("percent") && val != null) {
                    try {
                        percent = Integer.parseInt(val);
                        if (percent == 0) {
                            percent = 1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!TRACE || OracleLog.recursiveTrace) break block18;
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "(RLB)percent value= " + val + nfe, this);
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
            if (!key.equalsIgnoreCase("flag") || val == null) continue;
            if (val.equalsIgnoreCase("good")) {
                flag = 1;
                continue;
            }
            if (val.equalsIgnoreCase("violating")) {
                flag = 3;
                continue;
            }
            if (val.equalsIgnoreCase("NO_DATA")) {
                flag = 4;
                continue;
            }
            if (val.equalsIgnoreCase("UNKNOWN")) {
                flag = 2;
                continue;
            }
            if (!val.equalsIgnoreCase("BLOCKED")) continue;
            flag = 5;
        }
        icc.processDatabaseInstances();
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oicc) throws SQLException {
        this.cleanupFCFWorkerThread(oicc);
        oicc.cleanupRLBThreads();
        if (this.failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.failoverEnabledCacheCount;
    }

    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oicc) throws SQLException {
        if (oicc.failoverWorkerThread != null) {
            block4: {
                try {
                    if (oicc.failoverWorkerThread.isAlive()) {
                        oicc.failoverWorkerThread.join();
                    }
                }
                catch (InterruptedException e) {
                    if (!TRACE || OracleLog.recursiveTrace) break block4;
                    OracleLog.recursiveTrace = true;
                    OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheManager.cleanupFCFWorkerThread()" + e, this);
                    OracleLog.recursiveTrace = false;
                }
            }
            oicc.failoverWorkerThread = null;
        }
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        if (this.failoverEventHandlerThread != null) {
            block3: {
                try {
                    this.failoverEventHandlerThread.interrupt();
                }
                catch (Exception e) {
                    if (!TRACE || OracleLog.recursiveTrace) break block3;
                    OracleLog.recursiveTrace = true;
                    OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheManager.cleanupFCFEventHandlerThreadException" + e);
                    OracleLog.recursiveTrace = false;
                }
            }
            this.failoverEventHandlerThread = null;
        }
    }

    public boolean isFatalConnectionError(SQLException se) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.isFatalConnectionError()", this);
            OracleLog.recursiveTrace = false;
        }
        boolean retCode = false;
        int errCode = se.getErrorCode();
        if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
            retCode = true;
        }
        if (!retCode && this.fatalErrorCodes != null) {
            for (int i = 0; i < this.fatalErrorCodes.length; ++i) {
                if (errCode != this.fatalErrorCodes[i]) continue;
                retCode = true;
                break;
            }
        }
        return retCode;
    }

    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.setConnectionErrorCodes(" + fatalErrorCodes + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (fatalErrorCodes != null) {
            this.fatalErrorCodes = fatalErrorCodes;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheManager.getConnectionErrorCodes()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.fatalErrorCodes;
    }

    public Map getStatistics(String cacheName) throws SQLException {
        Map map = null;
        OracleImplicitConnectionCache icc = null;
        if (this.m_connCache != null && (icc = (OracleImplicitConnectionCache)this.m_connCache.get(cacheName)) != null) {
            map = icc.getStatistics();
        }
        return map;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

