/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected Vector locallySuspendedTransactions = new Vector();
    protected boolean canBeMigratablySuspended = false;
    protected XidListEntry xidHead = null;
    protected XidListEntry xidTail = null;
    protected XidListEntry currentXidListEntry = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:10_PST_2008";

    public OracleXAResource() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "oracle.jdbc.xa.OracleXAResource()", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "oracle.jdbc.xa.OracleXAResource(pm_conn = " + pm_conn + ", xaconn = " + xaconn + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.connection = pm_conn;
        this.xaconnection = xaconn;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    public synchronized void setConnection(Connection pm_conn) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.setConnection(pm_conn = " + pm_conn + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.connection = pm_conn;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    final XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry x = this.xidHead;
        while (x != null && !this.isSameXid(x.xid, xid)) {
            x = x.next;
        }
        return x;
    }

    protected final boolean removeXidFromList(Xid xid) {
        if (!this.isXidListEmpty()) {
            if (this.isSameXid(this.xidHead.xid, xid)) {
                this.xidHead = this.xidHead.next;
                if (this.xidHead == null) {
                    this.xidTail = this.xidHead;
                }
                return true;
            }
            XidListEntry x = this.xidHead.next;
            XidListEntry prev = this.xidHead;
            while (x != null) {
                if (this.isSameXid(x.xid, xid)) {
                    prev.next = x.next;
                    if (this.xidTail == x) {
                        this.xidTail = prev;
                    }
                    return true;
                }
                prev = x;
                x = x.next;
            }
        }
        return false;
    }

    final boolean isSameXid(Xid xid1, Xid xid2) {
        int i;
        if (xid1 == xid2) {
            return true;
        }
        byte[] xid1Gtrid = xid1.getGlobalTransactionId();
        byte[] xid2Gtrid = xid2.getGlobalTransactionId();
        byte[] xid1Bqual = xid1.getBranchQualifier();
        byte[] xid2Bqual = xid2.getBranchQualifier();
        if (xid1.getFormatId() != xid2.getFormatId() || xid1Gtrid == null || xid2Gtrid == null || xid1Bqual == null || xid2Bqual == null || xid1Gtrid.length != xid2Gtrid.length || xid1Bqual.length != xid2Bqual.length) {
            return false;
        }
        for (i = 0; i < xid1Gtrid.length; ++i) {
            if (xid1Gtrid[i] == xid2Gtrid[i]) continue;
            return false;
        }
        for (i = 0; i < xid1Bqual.length; ++i) {
            if (xid1Bqual[i] == xid2Bqual[i]) continue;
            return false;
        }
        return true;
    }

    protected final boolean isXidListEmpty() {
        return this.xidHead == null;
    }

    protected final boolean isCurrentXidSuspended(Xid xid) {
        return this.currentXidListEntry != null && this.isSameXid(this.currentXidListEntry.xid, xid) && this.currentXidListEntry.isSuspended;
    }

    protected void createOrUpdateXid(Xid xid, boolean isSuspended, boolean[] isLocallySuspended) {
        XidListEntry x;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): stacking xid", this);
            OracleLog.recursiveTrace = false;
        }
        if ((x = this.getMatchingXidListEntry(xid)) != null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.putXidToList (xid = " + xid + ", isSusended = " + isSuspended + " ): x(not supposed to be null) = " + x, this);
                OracleLog.recursiveTrace = false;
            }
            isLocallySuspended[0] = true;
            x.isSuspended = isSuspended;
        } else {
            x = new XidListEntry(xid, isSuspended);
            if (this.xidTail == null) {
                this.xidHead = this.xidTail = x;
            } else {
                this.xidTail.next = x;
                this.xidTail = x;
            }
        }
        if (!isSuspended) {
            this.enterGlobalTxnMode();
        }
        this.currentXidListEntry = x;
    }

    protected boolean updateXidList(Xid xid, boolean[] flags) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.updateXidList (" + xid + "): trying to clear stacked xid", this);
            OracleLog.recursiveTrace = false;
        }
        boolean foundXid = false;
        XidListEntry x = this.getMatchingXidListEntry(xid);
        if (x != null) {
            foundXid = true;
            flags[0] = true;
            flags[1] = x.isSuspended;
            if (x.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return foundXid;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.suspendStacked(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Xid stackedXid = null;
        if (!this.isXidListEmpty() && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
            stackedXid = this.xidTail.xid;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINER, "OracleXAResource.suspendStacked(xid): Before calling end()", this);
                OracleLog.recursiveTrace = false;
            }
            this.end(stackedXid, 0x2000000);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.suspendStacked(xid) return: " + stackedXid, this);
            OracleLog.recursiveTrace = false;
        }
        return stackedXid;
    }

    protected Xid suspendStacked(Xid xid, int endFlags) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.suspendStacked(xid = " + xid + ", endFlags = " + Integer.toHexString(endFlags) + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Xid stackedXid = null;
        if (endFlags == 0x4000000 && this.xidTail != null && this.currentXidListEntry != null && !this.isSameXid(this.currentXidListEntry.xid, xid)) {
            this.allowGlobalTxnModeOnly(-3);
            stackedXid = this.xidTail.xid;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINER, "OracleXAResource.suspendStacked(xid, endFlags): Before end()", this);
                OracleLog.recursiveTrace = false;
            }
            this.end(stackedXid, 0x2000000);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINER, "OracleXAResource.suspendStacked(xid, endFlags): Before start()", this);
                OracleLog.recursiveTrace = false;
            }
            this.start(xid, 0x8000000);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "suspendStacked(xid, endFlags) return: " + stackedXid, this);
            OracleLog.recursiveTrace = false;
        }
        return stackedXid;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "resumeStacked(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid != null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.resumeStacked(xid): Before calling start()", this);
                OracleLog.recursiveTrace = false;
            }
            this.start(xid, 0x8000000);
        }
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract int prepare(Xid var1) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public abstract void rollback(Xid var1) throws XAException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int flag) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAResource.recover(flag = " + flag + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if ((flag & 0x1800000) != flag) {
            if (!TRACE) throw new XAException(-5);
            if (OracleLog.recursiveTrace) throw new XAException(-5);
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.SEVERE, "OracleXAResource.recover(flag): XAER_INVAL, invalid flag", this);
            OracleLog.recursiveTrace = false;
            throw new XAException(-5);
        }
        Statement stmt = null;
        ResultSet rset = null;
        ArrayList<OracleXid> xidCollection = new ArrayList<OracleXid>(50);
        try {
            try {
                stmt = this.connection.createStatement();
                try {
                    stmt.execute(this.synchronizeBeforeRecoverNewCall);
                }
                catch (Exception exc) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleLog.xaLogger.log(Level.FINER, "OracleXAResource.recover(flag): DBMS_XA.dist_txn_sync failed: " + exc, this);
                        OracleLog.recursiveTrace = false;
                    }
                    stmt.execute(this.synchronizeBeforeRecoverOldCall);
                }
                rset = stmt.executeQuery(this.recoverySqlRows);
                while (rset.next()) {
                    xidCollection.add(new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3)));
                }
                Object var7_8 = null;
            }
            catch (SQLException sqe) {
                if (!TRACE) throw new XAException(-3);
                if (OracleLog.recursiveTrace) throw new XAException(-3);
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAResource.recover(flag): SQLException(internal) " + sqe, this);
                OracleLog.recursiveTrace = false;
                throw new XAException(-3);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rset == null) throw throwable;
                rset.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (stmt != null) {
            stmt.close();
        }
        if (rset != null) {
            rset.close();
        }
        int xidSize = xidCollection.size();
        Xid[] xids = new Xid[xidSize];
        System.arraycopy(xidCollection.toArray(), 0, xids, 0, xidSize);
        if (!TRACE) return xids;
        if (OracleLog.recursiveTrace) return xids;
        OracleLog.recursiveTrace = true;
        OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.recover(flag) return: " + xids, this);
        OracleLog.recursiveTrace = false;
        return xids;
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        block3: {
            if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
                try {
                    this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                    this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
                }
                catch (SQLException ignoreException) {
                    if (!TRACE || OracleLog.recursiveTrace) break block3;
                    OracleLog.recursiveTrace = true;
                    OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.restoreAutoCommitModeForGlobalTransaction got exception: " + ignoreException, this);
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        block2: {
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException ignoreException) {
                if (!TRACE || OracleLog.recursiveTrace) break block2;
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.saveAndAlterAutoCommitModeForGlobalTransaction got exception: " + ignoreException, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public void resume(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.resume(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.join(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.suspend(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int timeout) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.join(xid = " + xid + ", timeout = " + timeout + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.timeout = timeout;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int timeout) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.resume(xid = " + xid + ", timeout = " + timeout + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.timeout = timeout;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.getConnection()", this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.getConnection() return: " + this.connection, this);
            OracleLog.recursiveTrace = false;
        }
        return this.connection;
    }

    public int getTransactionTimeout() throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAResource.getTransactionTimeout()", this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.getTransactionTimeout() return: " + this.timeout, this);
            OracleLog.recursiveTrace = false;
        }
        return this.timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAResource.isSameRM(xares = " + xares + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Connection conn1 = null;
        if (!(xares instanceof OracleXAResource)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.isSameRM(xares) return: false", this);
                OracleLog.recursiveTrace = false;
            }
            return false;
        }
        conn1 = ((OracleXAResource)xares).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            String l_url = ((OracleConnection)this.connection).getURL();
            String l_prt = ((OracleConnection)this.connection).getProtocolType();
            if (conn1 != null) {
                boolean _returnVal;
                boolean bl = _returnVal = conn1.equals(this.connection) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.isSameRM(xares) return: " + _returnVal, this);
                    OracleLog.recursiveTrace = false;
                }
                return _returnVal;
            }
        }
        catch (SQLException sqe) {
            throw new XAException(-3);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.isSameRM(xares) return: false", this);
            OracleLog.recursiveTrace = false;
        }
        return false;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAResource.setTransactionTimeout(seconds = " + seconds + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.timeout = seconds;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.setTransactionTimeout(seconds) return: true", this);
            OracleLog.recursiveTrace = false;
        }
        return true;
    }

    public String getDBLink() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.getDBLink()", this);
            OracleLog.recursiveTrace = false;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.getDBLink() return: " + this.dblink, this);
            OracleLog.recursiveTrace = false;
        }
        return this.dblink;
    }

    public void setDBLink(String dblink) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.setDBLink(dblink = " + dblink + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.dblink = dblink;
    }

    public void setLogicalConnection(Connection conn) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.setLogicalConnection(conn = " + conn + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.logicalConnection = conn;
    }

    protected void allowGlobalTxnModeOnly(int errorCode) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.allowGlobalTxnModeOnly(errorCode = " + errorCode + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw new XAException(errorCode);
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int error) throws OracleXAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAResource.checkError(error = " + error + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if ((error & 0xFFFF) != 0) {
            throw new OracleXAException(error);
        }
    }

    protected void checkError(int error, int defaultXAError) throws OracleXAException {
        if ((error & 0xFFFF) != 0) {
            throw new OracleXAException(error, defaultXAError);
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;
        XidListEntry next = null;

        XidListEntry(Xid x, boolean s) {
            this.xid = x;
            this.isSuspended = s;
        }
    }
}

