/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXAHeteroCloseCallback
implements OracleCloseCallback {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:10_PST_2008";

    public synchronized void beforeClose(OracleConnection conn, Object obj) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroCloseCallback.beforeClose(conn = " + conn + ", obj = " + obj + ")", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public synchronized void afterClose(Object privData) {
        block5: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroCloseCallback.afterClose(privData = " + privData + ")", this);
                OracleLog.recursiveTrace = false;
            }
            int rmid = ((OracleXAHeteroConnection)privData).getRmid();
            String xaCloseString = ((OracleXAHeteroConnection)privData).getXaCloseString();
            try {
                int status = this.doXaClose(xaCloseString, rmid, 0, 0);
                if (status != 0) {
                    DatabaseError.throwSqlException(-1 * status);
                }
            }
            catch (SQLException sqlexc) {
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroCloseCallback.afterClose(): SQLException: " + sqlexc.getMessage(), this);
                OracleLog.recursiveTrace = false;
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroCloseCallback.afterClose() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    private native int doXaClose(String var1, int var2, int var3, int var4);

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroCloseCallback"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

