/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:52:00_PST_2008";

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] elements) throws SQLException {
        super(elements);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection conn) throws SQLException {
        if (conn == null) {
            DatabaseError.throwSqlException(68, "Connection is null");
        }
    }

    public static void assertNotNull(TypeDescriptor desc) throws SQLException {
        if (desc == null) {
            DatabaseError.throwSqlException(61);
        }
    }

    public void setPhysicalConnectionOf(Connection conn) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "DatumWithConnection.setPhysicalConnectionOf( conn=" + conn + ")");
            OracleLog.recursiveTrace = false;
        }
        this.physicalConnection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "DatumWithConnection.getJavaSqlConnection(): return", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "OPAQUE.getOracleConnection()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "ARRAY.getInternalConnection(): return", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getPhysicalConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "DatumWithConnection.getConnection() --- DEPRECATED --- Use getJavaSqlConnection() or get instead.", this);
            OracleLog.recursiveTrace = false;
        }
        OracleConnection ret = null;
        try {
            ret = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException ex) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.datumLogger.log(Level.SEVERE, "DatumWithConnection.getConnection: Wrong connection type. An exception is thrown." + ex.getMessage(), this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(103);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.datumLogger.log(Level.FINE, "DatumWithConnection.getConnection: return", this);
            OracleLog.recursiveTrace = false;
        }
        return ret;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.DatumWithConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

